/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.ceremony;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import org.apache.commons.lang3.Validate;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicInstrument;

public final class Ceremony {
    private final int musicNeeded;
    private final int maxStartupTime;
    private final Supplier<CeremonyInstance> factory;
    private final List<MusicInstrument> selectors;
    @Nullable
    private String descriptionId;

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, MusicInstrument selector1, MusicInstrument selector2) {
        this.musicNeeded = musicNeeded;
        this.maxStartupTime = maxStartupTime;
        this.factory = factory;
        this.selectors = List.of(selector1, selector2);
    }

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, Supplier<MusicInstrument> selector1, Supplier<MusicInstrument> selector2) {
        this(musicNeeded, maxStartupTime, factory, selector1.get(), selector2.get());
    }

    @Deprecated
    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, MusicInstrument ... selectors) {
        this(musicNeeded, maxStartupTime, factory, selectors[0], selectors[1]);
        Validate.inclusiveBetween((long)2L, (long)2L, (long)selectors.length, (String)"Invalid number of Cermeony selectors (must be between CeremonyAPI.MIN_SELECTORS and CeremonyAPI.MAX_SELECTORS)");
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"totemic.ceremony", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().ceremonies().getKey((Object)this);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public int getMusicNeeded() {
        return this.musicNeeded;
    }

    public int getMaxStartupTime() {
        return this.maxStartupTime;
    }

    public int getAdjustedMaxStartupTime(Difficulty diff) {
        return (int)((double)this.getMaxStartupTime() * TotemicAPI.get().ceremony().getStartupTimeMultiplier(diff));
    }

    public CeremonyInstance createInstance() {
        return this.factory.get();
    }

    public final List<MusicInstrument> getSelectors() {
        return this.selectors;
    }
}

