/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.ceremony;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.ceremony.CeremonyAPI;
import pokefenn.totemic.util.BlockUtil;

public enum CeremonyAPIImpl implements CeremonyAPI
{
    INSTANCE;


    @Override
    public void forEachBlockIn(Level level, BoundingBox box, BiConsumer<BlockPos, BlockState> action) {
        level.m_46473_().m_6174_("totemic.forEachBlockIn");
        SectionPos startSec = SectionPos.m_123199_((BlockPos)BlockUtil.lowerCorner(box));
        SectionPos endSec = SectionPos.m_123199_((BlockPos)BlockUtil.upperCorner(box));
        for (int chunkX = startSec.m_123341_(); chunkX <= endSec.m_123341_(); ++chunkX) {
            for (int chunkZ = startSec.m_123343_(); chunkZ <= endSec.m_123343_(); ++chunkZ) {
                if (!level.m_7232_(chunkX, chunkZ)) continue;
                LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
                for (int secY = startSec.m_123342_(); secY <= endSec.m_123342_(); ++secY) {
                    LevelChunkSection section;
                    if (secY < chunk.m_151560_() || secY >= chunk.m_151561_() || (section = chunk.m_183278_(chunk.m_151566_(secY))).m_188008_()) continue;
                    SectionPos secPos = SectionPos.m_123173_((int)chunkX, (int)secY, (int)chunkZ);
                    int secMinX = box.m_162395_() <= secPos.m_123229_() ? 0 : SectionPos.m_123207_((int)box.m_162395_());
                    int secMinY = box.m_162396_() <= secPos.m_123234_() ? 0 : SectionPos.m_123207_((int)box.m_162396_());
                    int secMinZ = box.m_162398_() <= secPos.m_123239_() ? 0 : SectionPos.m_123207_((int)box.m_162398_());
                    int secMaxX = box.m_162399_() >= secPos.m_123244_() ? 15 : SectionPos.m_123207_((int)box.m_162399_());
                    int secMaxY = box.m_162400_() >= secPos.m_123247_() ? 15 : SectionPos.m_123207_((int)box.m_162400_());
                    int secMaxZ = box.m_162401_() >= secPos.m_123248_() ? 15 : SectionPos.m_123207_((int)box.m_162401_());
                    for (int y = secMinY; y <= secMaxY; ++y) {
                        for (int z = secMinZ; z <= secMaxZ; ++z) {
                            for (int x = secMinX; x <= secMaxX; ++x) {
                                BlockPos pos = secPos.m_123249_().m_7918_(x, y, z);
                                BlockState state = section.m_62982_(x, y, z);
                                action.accept(pos, state);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public double getStartupTimeMultiplier(Difficulty diff) {
        return switch (diff) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL, Difficulty.EASY -> (Double)TotemicConfig.SERVER.ceremonyStartupTimeMultiplierEasy.get();
            case Difficulty.NORMAL -> (Double)TotemicConfig.SERVER.ceremonyStartupTimeMultiplierNormal.get();
            case Difficulty.HARD -> (Double)TotemicConfig.SERVER.ceremonyStartupTimeMultiplierHard.get();
        };
    }
}

