/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import pokefenn.totemic.block.DummyTipiBlock;
import pokefenn.totemic.init.ModBlocks;

public class TipiBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty OCCUPIED = BedBlock.f_49441_;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    private static final VoxelShape VISUAL_SHAPE = Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)6.25, (double)2.0);

    public TipiBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        return Optional.of(Vec3.m_82514_((Vec3i)pos, (double)0.0625));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)level)) {
            level.m_7471_(pos, false);
            this.removeDummyTipiBlocks(level, pos);
            Vec3 vec = pos.m_252807_();
            level.m_254951_(null, level.m_269111_().m_269488_(vec), null, vec, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        if (!level.m_45527_(pos.m_6630_(6))) {
            player.m_5661_((Component)Component.m_237115_((String)"block.totemic.tipi.cantSleep"), true);
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(problem -> {
            if (problem.m_36423_() != null) {
                player.m_5661_(problem.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.canPlaceTipi(ctx) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_()) : null;
    }

    private boolean canPlaceTipi(BlockPlaceContext ctx) {
        int y;
        BlockPos pos;
        Level level = ctx.m_43725_();
        BlockState belowState = level.m_8055_((pos = ctx.m_8083_()).m_7495_());
        if (!belowState.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        if (!belowState.m_60783_((BlockGetter)level, pos, Direction.UP)) {
            return false;
        }
        boolean radius = true;
        int middleHeight = 3;
        int totalHeight = 6;
        if (level.m_151562_(pos.m_123342_() + 6 - 1)) {
            Player player = ctx.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_240418_((Component)Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{level.m_151558_() - 1}).m_130940_(ChatFormatting.RED), true);
            }
            return false;
        }
        for (y = 0; y < 3; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    if (level.m_8055_(p).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)p, (Direction)Direction.DOWN))) continue;
                    return false;
                }
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.m_7918_(0, y, 0);
            if (level.m_8055_(p).m_60629_(BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)p, (Direction)Direction.DOWN))) continue;
            return false;
        }
        return true;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        int y;
        Direction facing = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        BlockState dummyTipiState = ((DummyTipiBlock)((Object)ModBlocks.dummy_tipi.get())).m_49966_();
        for (y = 0; y < 2; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (dir == facing) continue;
                BlockPos p = pos.m_121945_(dir).m_6630_(y);
                level.m_7731_(p, dummyTipiState, 7);
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.m_6630_(y);
            level.m_7731_(p, dummyTipiState, 7);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.removeDummyTipiBlocks(level, pos);
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        this.removeDummyTipiBlocks(level, pos);
        super.m_7592_(level, pos, explosion);
    }

    private void removeDummyTipiBlocks(Level level, BlockPos pos) {
        int y;
        BlockState airState = Blocks.f_50016_.m_49966_();
        for (y = 0; y < 2; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos p = pos.m_121945_(dir).m_6630_(y);
                if (!level.m_8055_(p).m_60713_((Block)ModBlocks.dummy_tipi.get())) continue;
                level.m_7731_(p, airState, 39);
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.m_6630_(y);
            if (!level.m_8055_(p).m_60713_((Block)ModBlocks.dummy_tipi.get())) continue;
            level.m_7731_(p, airState, 39);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return VISUAL_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, OCCUPIED});
    }
}

