/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.music.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.util.BlockUtil;

public class WindChimeBlockEntity
extends BlockEntity {
    public static final int CONGESTION_RANGE = 8;
    public static final int MAX_NEARBY_CHIMES = 2;
    private int playingTimeLeft = 0;
    private int cooldown = 0;
    private boolean isCongested = false;
    private static final int PLAYING_TIME = 160;

    public WindChimeBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.wind_chime.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindChimeBlockEntity tile) {
        if (tile.isPlaying()) {
            if (tile.playingTimeLeft % 40 == 0) {
                tile.playMusic(level, pos, state);
            }
            --tile.playingTimeLeft;
            if (tile.playingTimeLeft <= 0) {
                tile.setNotPlaying();
            }
        } else {
            if (!tile.isCongested && !level.f_46443_) {
                --tile.cooldown;
                if (tile.cooldown <= 0) {
                    tile.setPlaying(160);
                }
            }
            if (tile.isCongested && level.f_46443_) {
                tile.congestionParticles();
            }
        }
    }

    private void playMusic(Level level, BlockPos pos, BlockState state) {
        BlockState above = level.m_8055_(pos.m_7494_());
        int baseAmount = ((MusicInstrument)ModContent.wind_chime.get()).getBaseOutput();
        int bonus = above.m_204336_(BlockTags.f_13035_) ? baseAmount / 2 : 0;
        TotemicAPI.get().music().playMusic(level, Vec3.m_82539_((Vec3i)pos), null, (MusicInstrument)ModContent.wind_chime.get(), 5, baseAmount + bonus);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.isCongested = this.checkForCongestion();
        }
    }

    public boolean isPlaying() {
        return this.playingTimeLeft > 0 && !this.isCongested;
    }

    public void setPlaying(int time) {
        this.playingTimeLeft = time;
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, time);
        }
        this.m_6596_();
    }

    public void setNotPlaying() {
        this.playingTimeLeft = 0;
        if (!this.f_58857_.f_46443_) {
            this.cooldown = this.getRandomCooldown(this.f_58857_.f_46441_);
        }
        this.m_6596_();
    }

    public boolean m_7531_(int id, int param) {
        if (!this.f_58857_.f_46443_) {
            return true;
        }
        this.setPlaying(param);
        return true;
    }

    private int getRandomCooldown(RandomSource rand) {
        return (int)(20.0 * (40.0 + 5.0 * rand.m_188583_()));
    }

    private boolean checkForCongestion() {
        long count = BlockUtil.getBlockEntitiesInRange((BlockEntityType)ModBlockEntities.wind_chime.get(), this.f_58857_, this.f_58858_, 8).filter(tile -> tile != this && !tile.isCongested).limit(3L).count();
        return count > 2L;
    }

    public void tryUncongest() {
        if (this.isCongested) {
            this.isCongested = this.checkForCongestion();
            if (!this.isCongested) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    private void congestionParticles() {
        if (this.f_58857_.m_46467_() % 2L == 0L) {
            RandomSource rand = this.f_58857_.m_213780_();
            BlockPos pos = this.m_58899_();
            this.f_58857_.m_7107_((ParticleOptions)ParticleTypes.f_123797_, (double)((float)pos.m_123341_() + rand.m_188501_()), (double)((float)pos.m_123342_() + rand.m_188501_()), (double)((float)pos.m_123343_() + rand.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.isPlaying()) {
            tag.m_128405_("PlayingTime", this.playingTimeLeft);
        } else {
            tag.m_128405_("Cooldown", this.cooldown);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("PlayingTime")) {
            this.playingTimeLeft = tag.m_128451_("PlayingTime");
        } else {
            this.playingTimeLeft = 0;
            this.cooldown = tag.m_128451_("Cooldown");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("PlayingTime", this.playingTimeLeft);
        tag.m_128379_("IsCongested", this.isCongested);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.playingTimeLeft = tag.m_128451_("PlayingTime");
        this.isCongested = tag.m_128471_("IsCongested");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }
}

