/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicEventHooks;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.util.MiscUtil;

public final class StateCeremonyEffect
extends TotemState
implements CeremonyEffectContext {
    static final byte ID = 3;
    private Ceremony ceremony;
    private CeremonyInstance instance;
    @Nullable
    private Entity initiator;
    private int time = 0;

    StateCeremonyEffect(TotemBaseBlockEntity tile, Ceremony ceremony, CeremonyInstance instance, @Nullable Entity initiator) {
        super(tile);
        this.ceremony = ceremony;
        this.instance = instance;
        this.initiator = initiator;
    }

    StateCeremonyEffect(TotemBaseBlockEntity tile) {
        super(tile);
    }

    @Override
    public boolean canAcceptMusic(MusicInstrument instr) {
        return false;
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        return MusicAcceptor.MusicResult.FAILURE;
    }

    @Override
    public void tick() {
        Level world = this.tile.m_58904_();
        BlockPos pos = this.tile.m_58899_();
        if (TotemicEventHooks.get().fireCeremonyEffectTick((LevelAccessor)world, pos, this.ceremony, this.instance, this)) {
            this.instance.effect(world, pos, this);
        }
        ++this.time;
        if (!world.f_46443_) {
            if (this.time >= this.instance.getEffectTime()) {
                this.tile.setTotemState(new StateTotemEffect(this.tile));
            }
        } else if (this.instance.getEffectTime() == 0) {
            this.tile.setTotemState(new StateTotemEffect(this.tile));
        } else {
            CeremonyHUD.INSTANCE.setActiveTotem(this.tile);
        }
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public int getAnalogOutputSignal() {
        return 15;
    }

    @Override
    public Optional<Player> getInitiatingPlayer() {
        return MiscUtil.filterAndCast(this.getInitiator(), Player.class);
    }

    @Override
    public Optional<Entity> getInitiator() {
        return Optional.ofNullable(this.initiator);
    }

    @Override
    public void endCeremony() {
        this.tile.setTotemState(new StateTotemEffect(this.tile));
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    public CeremonyInstance getCeremonyInstance() {
        return this.instance;
    }

    @Override
    byte getID() {
        return 3;
    }

    @Override
    void save(CompoundTag tag) {
        tag.m_128359_("Ceremony", this.ceremony.getRegistryName().toString());
        Tag instanceData = this.instance.serializeNBT();
        if (instanceData != EndTag.f_128534_) {
            tag.m_128365_("InstanceData", instanceData);
        }
        tag.m_128405_("Time", this.time);
    }

    @Override
    void load(CompoundTag tag) {
        String ceremonyName = tag.m_128461_("Ceremony");
        this.ceremony = (Ceremony)TotemicAPI.get().registry().ceremonies().getValue(ResourceLocation.m_135820_((String)ceremonyName));
        if (this.ceremony == null) {
            Totemic.logger.error("Unknown Ceremony: '{}'", (Object)ceremonyName);
            this.tile.setTotemState(new StateTotemEffect(this.tile));
            return;
        }
        this.instance = this.ceremony.createInstance();
        if (tag.m_128441_("InstanceData")) {
            this.instance.deserializeNBT(tag.m_128423_("InstanceData"));
        }
        this.time = tag.m_128451_("Time");
    }
}

