/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;

public class TotemPoleBlockEntity
extends BlockEntity {
    private ResourceLocation woodTypeLoc = ModContent.oak.getId();
    private ResourceLocation carvingLoc = ModContent.none.getId();
    private volatile TotemWoodType woodType = (TotemWoodType)ModContent.oak.get();
    private volatile TotemCarving carving = (TotemCarving)ModContent.none.get();

    public TotemPoleBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.totem_pole.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Wood", this.woodTypeLoc.toString());
        tag.m_128359_("Carving", this.carvingLoc.toString());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.woodTypeLoc = Objects.requireNonNullElse(ResourceLocation.m_135820_((String)tag.m_128461_("Wood")), ModContent.oak.getId());
        if (!TotemicAPI.get().registry().woodTypes().containsKey(this.woodTypeLoc)) {
            Totemic.logger.warn("Unknown Totem Wood Type: '{}'", (Object)this.woodTypeLoc);
        }
        this.woodType = (TotemWoodType)TotemicAPI.get().registry().woodTypes().getValue(this.woodTypeLoc);
        this.carvingLoc = Objects.requireNonNullElse(ResourceLocation.m_135820_((String)tag.m_128461_("Carving")), ModContent.none.getId());
        if (!TotemicAPI.get().registry().totemCarvings().containsKey(this.carvingLoc)) {
            Totemic.logger.warn("Unknown Totem Carving: '{}'", (Object)this.carvingLoc);
        }
        this.carving = (TotemCarving)TotemicAPI.get().registry().totemCarvings().getValue(this.carvingLoc);
        this.requestModelDataUpdate();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public TotemWoodType getWoodType() {
        return this.woodType;
    }

    public TotemCarving getCarving() {
        return this.carving;
    }

    public void setAppearance(TotemWoodType woodType, TotemCarving carving) {
        this.woodType = Objects.requireNonNull(woodType);
        this.woodTypeLoc = woodType.getRegistryName();
        this.carving = Objects.requireNonNull(carving);
        this.carvingLoc = carving.getRegistryName();
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(TotemPoleModelData.DATA_PROPERTY, (Object)new TotemPoleModelData(this.woodType, this.carving)).build();
    }
}

