/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicEntityTypeTags;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.util.MiscUtil;

public enum AnimalGrowthCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 8;
    private static final int TURTLE_HATCH_RADIUS = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (context.getTime() % 20 == 0) {
            AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
            AnimalGrowthCeremony.growAnimals(level, aabb);
            AnimalGrowthCeremony.hatchChickenEggs(level, aabb);
            AnimalGrowthCeremony.hatchTurtleEggs(level, pos);
        }
    }

    private static void growAnimals(Level level, AABB aabb) {
        level.m_6443_(Animal.class, aabb, animal -> animal.m_6162_() && !animal.m_6095_().m_204039_(TotemicEntityTypeTags.HYMN_OF_MATURITY_BLACKLIST)).forEach(animal -> {
            if (level.f_46441_.m_188503_(4) == 0) {
                if (!level.f_46443_) {
                    animal.m_146758_(level.f_46441_.m_188503_(60));
                } else {
                    AABB animalBB = animal.m_20191_();
                    AnimalGrowthCeremony.spawnParticles(level, animal.m_20182_().m_82520_(0.0, animalBB.m_82376_() * 0.5, 0.0), animalBB.m_82362_() * 0.5, animalBB.m_82376_() * 0.5, animalBB.m_82385_() * 0.5);
                }
            }
        });
    }

    private static void hatchChickenEggs(Level level, AABB aabb) {
        if (!level.f_46443_) {
            level.m_142425_((EntityTypeTest)EntityType.f_20461_, aabb, e -> e.m_32055_().m_150930_(Items.f_42521_)).forEach(egg -> {
                if (level.f_46441_.m_188503_(4) == 0) {
                    MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123748_, level, egg.m_20182_(), 10, new Vec3(0.5, 0.5, 0.5), 1.0);
                    Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(level);
                    if (chicken == null) {
                        return;
                    }
                    chicken.m_146762_(-24000);
                    chicken.m_7678_(egg.m_20185_(), egg.m_20186_(), egg.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
                    level.m_7967_((Entity)chicken);
                    MiscUtil.shrinkItemEntity(egg);
                }
            });
        }
    }

    private static void hatchTurtleEggs(Level level, BlockPos pos) {
        TotemicAPI.get().ceremony().forEachBlockIn(level, TotemicEntityUtil.getBoundingBoxAround(pos, 6), (p, state) -> {
            if (state.m_60713_(Blocks.f_50578_) && TurtleEggBlock.m_57762_((BlockGetter)level, (BlockPos)p)) {
                if (!level.f_46443_) {
                    if (level.f_46441_.m_188503_(45) == 0) {
                        AnimalGrowthCeremony.hatchTurtleEgg(level, p, state);
                    }
                } else if (level.f_46441_.m_188503_(4) == 0) {
                    AnimalGrowthCeremony.spawnParticles(level, Vec3.m_82539_((Vec3i)p).m_82520_(0.0, 0.25, 0.0), 0.5, 0.5, 0.5);
                }
            }
        });
    }

    private static void hatchTurtleEgg(Level level, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)TurtleEggBlock.f_57753_);
        if (age < 2) {
            level.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurtleEggBlock.f_57753_, (Comparable)Integer.valueOf(age + 1)), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        } else {
            level.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_7471_(pos, false);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            for (int j = 0; j < (Integer)state.m_61143_((Property)TurtleEggBlock.f_57754_); ++j) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                Turtle turtle = (Turtle)EntityType.f_20490_.m_20615_(level);
                if (turtle == null) continue;
                turtle.m_146762_(-24000);
                turtle.m_30219_(pos);
                turtle.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                level.m_7967_((Entity)turtle);
            }
        }
    }

    private static void spawnParticles(Level level, Vec3 pos, double xSpread, double ySpread, double zSpread) {
        RandomSource rand = level.f_46441_;
        for (int i = 0; i < 10; ++i) {
            Vec3 vec = pos.m_82520_(rand.m_188583_() * xSpread, rand.m_188583_() * ySpread, rand.m_188583_() * zSpread);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getEffectTime() {
        return 900;
    }
}

