/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.util.MiscUtil;

public enum FertilityCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 8;
    private static final int SAPLING_TRANSFORM_RADIUS = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (level.f_46443_) {
            return;
        }
        if (context.getTime() % 20 == 0) {
            FertilityCeremony.transformSaplings(level, pos);
            FertilityCeremony.breedAnimalsAndVillagers(level, pos, context);
        }
    }

    private static void transformSaplings(Level level, BlockPos pos) {
        BlockPos.m_121919_((BoundingBox)TotemicEntityUtil.getBoundingBoxAround(pos, 6)).filter(p -> {
            BlockState state = level.m_8055_(p);
            return state.m_204336_(BlockTags.f_13104_) && state.m_60734_() != ModBlocks.cedar_sapling.get();
        }).findAny().ifPresent(p -> {
            level.m_7731_(p, ((SaplingBlock)ModBlocks.cedar_sapling.get()).m_49966_(), 3);
            MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123748_, level, Vec3.m_82512_((Vec3i)p), 10, new Vec3(0.5, 0.5, 0.5), 0.0);
        });
    }

    private static void breedAnimalsAndVillagers(Level level, BlockPos pos, CeremonyEffectContext context) {
        AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
        for (Animal animal : level.m_6443_(Animal.class, aabb, a -> a.m_146764_() == 0 && !a.m_27593_())) {
            Optional<ItemEntity> itemE = FertilityCeremony.findItemEntity(level, pos, arg_0 -> ((Animal)animal).m_6898_(arg_0));
            if (!itemE.isPresent()) continue;
            if (level.f_46441_.m_188503_(3) < 2) {
                MiscUtil.shrinkItemEntity(itemE.get());
            }
            animal.m_27595_((Player)context.getInitiatingPlayer().orElse(null));
            return;
        }
    }

    private static Optional<ItemEntity> findItemEntity(Level level, BlockPos pos, Predicate<ItemStack> predicate) {
        List list = level.m_142425_((EntityTypeTest)EntityType.f_20461_, TotemicEntityUtil.getAABBAround(pos, 8.0), e -> predicate.test(e.m_32055_()));
        return !list.isEmpty() ? Optional.of((ItemEntity)list.get(0)) : Optional.empty();
    }

    @Override
    public int getEffectTime() {
        return 400;
    }
}

