/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;

public enum CeremonyHUD implements IGuiOverlay
{
    INSTANCE;

    private static final ResourceLocation SELECTION_HUD_TEXTURE;
    private static final ResourceLocation CEREMONY_HUD_TEXTURE;
    private static final Component SELECTION_TEXT;
    private static final int HUD_WIDTH = 117;
    private static final int HUD_HEIGHT = 30;
    private TotemBaseBlockEntity activeTotem = null;

    public void setActiveTotem(TotemBaseBlockEntity tile) {
        if (tile.m_58899_().m_203193_((Position)Minecraft.m_91087_().m_91288_().m_20182_()) <= 64.0) {
            this.activeTotem = tile;
        } else if (this.activeTotem == tile) {
            this.activeTotem = null;
        }
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (this.activeTotem == null) {
            return;
        }
        Minecraft mc = gui.getMinecraft();
        mc.m_91307_().m_6180_("totemic.ceremonyHUD");
        if (this.activeTotem.m_58901_() || this.activeTotem.m_58904_() != mc.f_91073_ || this.activeTotem.getTotemState() instanceof StateTotemEffect) {
            this.activeTotem = null;
            return;
        }
        int hudX = (screenWidth - 117) / 2 + (Integer)TotemicConfig.CLIENT.ceremonyHudPositionX.get();
        int hudY = (screenHeight - 30) / 2 + (Integer)TotemicConfig.CLIENT.ceremonyHudPositionY.get();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)hudX, (float)hudY, 0.0f);
        TotemState state = this.activeTotem.getTotemState();
        if (state instanceof StateSelection) {
            StateSelection s = (StateSelection)state;
            this.renderSelectionHUD(s, gui, guiGraphics, partialTick, hudX, hudY);
        } else if (state instanceof StateStartup) {
            StateStartup s = (StateStartup)state;
            this.renderStartupHUD(s, gui, guiGraphics, partialTick);
        } else if (state instanceof StateCeremonyEffect) {
            StateCeremonyEffect s = (StateCeremonyEffect)state;
            this.renderCeremonyEffectHUD(s, gui, guiGraphics, partialTick);
        }
        poseStack.m_85849_();
        mc.m_91307_().m_7238_();
    }

    private void renderSelectionHUD(StateSelection state, ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int hudX, int hudY) {
        int texW = 128;
        int texH = 64;
        gui.setupOverlayRenderState(true, false);
        guiGraphics.m_280163_(SELECTION_HUD_TEXTURE, 0, 0, 0.0f, 0.0f, 117, 30, 128, 64);
        int headerX = (117 - gui.m_93082_().m_92852_((FormattedText)SELECTION_TEXT)) / 2;
        guiGraphics.m_280614_(gui.m_93082_(), SELECTION_TEXT, headerX, 2, -939524096, false);
        List<MusicInstrument> selectors = state.getSelectors();
        if (!selectors.isEmpty()) {
            ItemStack item = selectors.get(0).getItem();
            guiGraphics.m_280480_(item, 40, 12);
        }
    }

    private void renderStartupHUD(StateStartup state, ForgeGui gui, GuiGraphics guiGraphics, float partialTick) {
        int texW = 128;
        int texH = 64;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        gui.setupOverlayRenderState(true, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CEREMONY_HUD_TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        PoseStack poseStack = guiGraphics.m_280168_();
        CeremonyHUD.addQuad(buf, poseStack, 0.0f, 0.0f, 117.0f, 30.0f, 0.0f, 0.0f, 117.0f, 30.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 10.0f, 9.0f, 9.0f, 16.0f, 48.0f, 8.0f, 8.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 20.0f, 9.0f, 9.0f, 0.0f, 48.0f, 16.0f, 16.0f, 128, 64);
        float musicW = (float)state.getTotalMusic() / (float)cer.getMusicNeeded() * 104.0f;
        float timeW = Math.min(((float)state.getTime() + partialTick) / (float)cer.getAdjustedMaxStartupTime(gui.getMinecraft().f_91073_.m_46791_()), 1.0f) * 104.0f;
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 11.0f, musicW, 7.0f, 0.0f, 32.0f, musicW, 7.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 21.0f, timeW, 7.0f, 0.0f, 32.0f, timeW, 7.0f, 128, 64);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        MutableComponent name = cer.getDisplayName();
        int nameX = (117 - gui.m_93082_().m_92852_((FormattedText)name)) / 2;
        guiGraphics.m_280614_(gui.m_93082_(), (Component)name, nameX, 2, -939524096, false);
    }

    private void renderCeremonyEffectHUD(StateCeremonyEffect state, ForgeGui gui, GuiGraphics guiGraphics, float partialTick) {
        int texW = 128;
        int texH = 64;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        CeremonyInstance cerInst = state.getCeremonyInstance();
        gui.setupOverlayRenderState(true, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CEREMONY_HUD_TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        PoseStack poseStack = guiGraphics.m_280168_();
        CeremonyHUD.addQuad(buf, poseStack, 0.0f, 0.0f, 117.0f, 30.0f, 0.0f, 0.0f, 117.0f, 30.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 20.0f, 9.0f, 9.0f, 0.0f, 48.0f, 16.0f, 16.0f, 128, 64);
        float timeW = Mth.m_14036_((float)(1.0f - ((float)state.getTime() + partialTick) / (float)cerInst.getEffectTime()), (float)0.0f, (float)1.0f) * 104.0f;
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 21.0f, timeW, 7.0f, 0.0f, 32.0f, timeW, 7.0f, 128, 64);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        MutableComponent name = cer.getDisplayName();
        int nameX = (117 - gui.m_93082_().m_92852_((FormattedText)name)) / 2;
        guiGraphics.m_280614_(gui.m_93082_(), (Component)name, nameX, 2, -939524096, false);
    }

    private static void addQuad(BufferBuilder buf, PoseStack ps, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        Matrix4f mat = ps.m_85850_().m_252922_();
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + vHeight) / (float)textureHeight;
        buf.m_252986_(mat, x, y + height, 0.0f).m_7421_(minU, maxV).m_5752_();
        buf.m_252986_(mat, x + width, y + height, 0.0f).m_7421_(maxU, maxV).m_5752_();
        buf.m_252986_(mat, x + width, y, 0.0f).m_7421_(maxU, minV).m_5752_();
        buf.m_252986_(mat, x, y, 0.0f).m_7421_(minU, minV).m_5752_();
    }

    static {
        SELECTION_HUD_TEXTURE = Totemic.resloc("textures/gui/selection_hud.png");
        CEREMONY_HUD_TEXTURE = Totemic.resloc("textures/gui/ceremony_hud.png");
        SELECTION_TEXT = Component.m_237115_((String)"totemic.hud.selection");
    }
}

