/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model.totem;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.registries.IForgeRegistry;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.BakedTotemBaseModel;

public final class TotemBaseModel
implements IUnbakedGeometry<TotemBaseModel> {
    private Map<TotemWoodType, UnbakedModel> totemModels = null;

    private TotemBaseModel() {
    }

    public BakedModel bake(IGeometryBakingContext ctx, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        Map<TotemWoodType, BakedModel> bakedModels = Map.copyOf(Maps.transformValues(this.totemModels, unbaked -> unbaked.m_7611_(bakery, spriteGetter, modelState, modelLocation)));
        return new BakedTotemBaseModel(bakedModels);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        if (this.totemModels == null) {
            IForgeRegistry<TotemWoodType> woodTypeRegistry = TotemicAPI.get().registry().woodTypes();
            this.totemModels = Maps.newHashMapWithExpectedSize((int)woodTypeRegistry.getValues().size());
            for (TotemWoodType woodType : woodTypeRegistry) {
                UnbakedModel model = modelGetter.apply(TotemBaseModel.getWoodTypeModelName(woodType));
                this.totemModels.put(woodType, model);
                model.m_5500_(modelGetter);
            }
        }
    }

    private static ResourceLocation getWoodTypeModelName(TotemWoodType woodType) {
        ResourceLocation woodName = woodType.getRegistryName();
        return new ResourceLocation(woodName.m_135827_(), "block/" + woodName.m_135815_() + "_totem_base");
    }

    public static enum Loader implements IGeometryLoader<TotemBaseModel>
    {
        INSTANCE;


        public TotemBaseModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new TotemBaseModel();
        }
    }
}

