/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.koopascritters.entity;

import net.mcreator.koopascritters.entity.AardwolfKCEntity;
import net.mcreator.koopascritters.entity.CaliforniaQuailEntity;
import net.mcreator.koopascritters.entity.HelmetedGuineafowlEntity;
import net.mcreator.koopascritters.entity.PallasCatEntity;
import net.mcreator.koopascritters.entity.ViscachaEntity;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TibetanFoxEntity
extends PathfinderMob {
    public TibetanFoxEntity(EntityType<TibetanFoxEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AardwolfKCEntity.class, true, true));
        this.goalSelector.addGoal(5, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal(this, this, 1.4, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, ViscachaEntity.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, CaliforniaQuailEntity.class, true, true));
        this.goalSelector.addGoal(11, (Goal)new AvoidEntityGoal((PathfinderMob)this, HelmetedGuineafowlEntity.class, 12.0f, 1.0, 1.2));
        this.goalSelector.addGoal(12, (Goal)new AvoidEntityGoal((PathfinderMob)this, PallasCatEntity.class, 12.0f, 1.0, 1.2));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)Blocks.WHITE_WOOL));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.23);
        builder = builder.add(Attributes.MAX_HEALTH, 11.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

