/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class LifeJacketBeltItem
extends UAUniqueCurioItem {
    public LifeJacketBeltItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "belt";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.life_jacket_belt.desc1").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"belt".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (!e.m_6084_() || e.m_5833_() || e.m_21255_() || e.m_20077_() || e.m_20159_()) {
            return;
        }
        if (!e.m_20072_()) {
            return;
        }
        Vec3 v = e.m_20184_();
        if (e.m_6047_()) {
            double y = Math.min(v.f_82480_, -0.08);
            e.m_20334_(v.f_82479_ * 0.9, y, v.f_82481_ * 0.9);
            e.f_19789_ = 0.0f;
            return;
        }
        double surfaceY = LifeJacketBeltItem.getTopWaterSurfaceY(e);
        if (!Double.isNaN(surfaceY)) {
            double waistY = e.m_20186_() + (double)e.m_20206_() * 0.5;
            double desiredWaistY = surfaceY - 0.2;
            double err = desiredWaistY - waistY;
            double vy = Mth.m_14008_((double)(err * 0.4), (double)-0.2, (double)0.25);
            e.m_20334_(v.f_82479_ * 0.9, Math.max(v.f_82480_, vy) * 1.2, v.f_82481_ * 0.9);
            e.f_19789_ = 0.0f;
            return;
        }
        double targetUp = 0.12;
        double y = v.f_82480_ < targetUp ? targetUp : v.f_82480_;
        e.m_20334_(v.f_82479_ * 0.9, Math.min(y, 0.3), v.f_82481_ * 0.9);
        e.f_19789_ = 0.0f;
    }

    private static double getTopWaterSurfaceY(LivingEntity e) {
        BlockPos pos;
        Level level = e.m_9236_();
        if (!level.m_6425_(pos = BlockPos.m_274561_((double)e.m_20185_(), (double)Math.floor(e.m_20186_()), (double)e.m_20189_())).m_205070_(FluidTags.f_13131_)) {
            BlockPos up = pos.m_7494_();
            if (!level.m_6425_(up).m_205070_(FluidTags.f_13131_)) {
                return Double.NaN;
            }
            pos = up;
        }
        int guard = 32;
        while (guard-- > 0 && level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_)) {
            pos = pos.m_7494_();
        }
        return (double)pos.m_123342_() + 1.0;
    }

    private static boolean isEyesInWater(LivingEntity e) {
        BlockPos eye = BlockPos.m_274446_((Position)e.m_146892_());
        FluidState fs = e.m_9236_().m_6425_(eye);
        return fs.m_205070_(FluidTags.f_13131_);
    }
}

