/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class GenericRecipeRegistry<C extends RecipeInput, T extends Recipe<C>> {
    private final Supplier<? extends RecipeType<? extends T>> type;
    public List<RecipeHolder<? extends T>> RECIPES = new ArrayList<RecipeHolder<? extends T>>();
    public static List<GenericRecipeRegistry<?, ?>> REGISTRIES = new ArrayList();

    public GenericRecipeRegistry(Supplier<? extends RecipeType<? extends T>> type) {
        this.type = type;
        REGISTRIES.add(this);
    }

    public List<RecipeHolder<? extends T>> getRecipes() {
        return Collections.unmodifiableList(this.RECIPES);
    }

    public RecipeType<? extends T> getType() {
        return this.type.get();
    }

    public void reload(RecipeManager manager) {
        this.RECIPES.clear();
        List recipes = manager.getAllRecipesFor(this.type.get());
        this.RECIPES.addAll(recipes);
    }

    public static void reloadAll(RecipeManager recipeManager) {
        for (GenericRecipeRegistry<?, ?> registry : REGISTRIES) {
            registry.reload(recipeManager);
        }
    }
}

