/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.SchoolTooltip;
import com.hollingsworth.arsnouveau.client.gui.SearchBar;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.book.EnterTextField;
import com.hollingsworth.arsnouveau.client.gui.book.GuiFamiliarScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSettingsScreen;
import com.hollingsworth.arsnouveau.client.gui.book.ParticleOverviewScreen;
import com.hollingsworth.arsnouveau.client.gui.book.SpellSlottedScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.ClearButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.CraftingButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.CreateSpellButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateParticleTimeline;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphKnownValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphMaxTierValidator;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GuiSpellBook
extends SpellSlottedScreen {
    public int numLinks = 10;
    public EnterTextField spellNameBox;
    public SearchBar searchBar;
    public List<CraftingButton> craftingCells = new ArrayList<CraftingButton>();
    public List<AbstractSpellPart> unlockedSpells;
    public List<AbstractSpellPart> displayedGlyphs;
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    public int page = 0;
    public PageButton nextButton;
    public PageButton previousButton;
    public ISpellValidator spellValidator;
    public ISpellValidator pasteValidator;
    public String previousString = "";
    public int formTextRow = 0;
    public int augmentTextRow = 0;
    public int effectTextRow = 0;
    public int glyphsPerPage = 58;
    public int maxManaCache = 0;
    int currentCostCache = 0;
    public Renderable hoveredWidget = null;
    public List<AbstractSpellPart> spell = new ArrayList<AbstractSpellPart>();
    public PageButton nextGlyphButton;
    public PageButton prevGlyphButton;
    public int spellWindowOffset = 0;
    public int bonusSlots = 0;
    public String spellname = "";
    public long timeOpened;

    public GuiSpellBook(InteractionHand hand) {
        super(hand);
        AbstractCaster<?> caster;
        ArrayList<AbstractSpellPart> parts = this.playerCap == null ? new ArrayList<AbstractSpellPart>() : new ArrayList<AbstractSpellPart>(this.playerCap.getKnownGlyphs().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
        this.maxManaCache = ManaUtil.getMaxMana(this.player);
        parts.addAll(GlyphRegistry.getDefaultStartingSpells());
        int tier = 1;
        Item item = this.bookStack.getItem();
        if (item instanceof SpellBook) {
            SpellBook book = (SpellBook)item;
            tier = book.getTier().value;
            if (book.getTier() == SpellTier.CREATIVE) {
                parts = new ArrayList<AbstractSpellPart>(GlyphRegistry.getSpellpartMap().values().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
            }
        }
        if (SpellCasterRegistry.hasCaster(this.bookStack) && (caster = SpellCasterRegistry.from(this.bookStack)) != null) {
            this.bonusSlots = caster.getBonusGlyphSlots();
        }
        this.unlockedSpells = parts;
        this.displayedGlyphs = new ArrayList<AbstractSpellPart>(this.unlockedSpells);
        this.validationErrors = new LinkedList();
        this.spellValidator = new CombinedSpellValidator(ArsNouveauAPI.getInstance().getSpellCraftingSpellValidator(), new GlyphMaxTierValidator(tier));
        this.pasteValidator = new CombinedSpellValidator(ArsNouveauAPI.getInstance().getSpellCraftingSpellValidator(), new GlyphMaxTierValidator(tier), new GlyphKnownValidator(this.player.isCreative() || this.bookStack.is(ItemsRegistry.CREATIVE_SPELLBOOK.asItem()) ? null : this.playerCap));
        this.spell = SpellCasterRegistry.from((ItemStack)this.bookStack).getSpell((int)this.selectedSpellSlot).mutable().recipe;
    }

    @Override
    public void onBookstackUpdated(ItemStack stack) {
        super.onBookstackUpdated(stack);
        this.onSetCaster(this.selectedSpellSlot);
        this.rebuildWidgets();
    }

    private void onSetCaster(int slot) {
        this.selectedSpellSlot = slot;
        if (this.spellNameBox != null) {
            this.spellNameBox.setValue(this.caster.getSpellName(slot));
        }
        this.spell = SpellCasterRegistry.from((ItemStack)this.bookStack).getSpell((int)this.selectedSpellSlot).mutable().recipe;
    }

    @Override
    public void init() {
        super.init();
        this.timeOpened = System.currentTimeMillis();
        this.craftingCells = new ArrayList<CraftingButton>();
        this.resetCraftingCells();
        this.layoutAllGlyphs(this.page);
        this.addRenderableWidget((GuiEventListener)new CreateSpellButton(this.bookRight - 74, this.bookBottom - 13, b -> this.saveSpell(), () -> this.validationErrors));
        this.addRenderableWidget((GuiEventListener)new ClearButton(this.bookRight - 129, this.bookBottom - 13, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.clear"), this::clear));
        String previousSearch = "";
        if (this.searchBar != null) {
            previousSearch = this.searchBar.getValue();
        }
        this.searchBar = new SearchBar(Minecraft.getInstance().font, this.bookRight - 130, this.bookTop - 3);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        this.searchBar.setValue(previousSearch);
        this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
        this.searchBar.setResponder(this::onSearchChanged);
        this.spellNameBox = new EnterTextField(this.minecraft.font, this.bookLeft + 16, this.bookBottom - 13);
        this.spellNameBox.setValue(this.caster.getSpellName(this.selectedSpellSlot));
        this.addRenderableWidget((GuiEventListener)this.spellNameBox);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.initSpellSlots(slotButton -> {
            this.onSetCaster(this.selectedSpellSlot);
            this.resetCraftingCells();
            this.updateWindowOffset(0);
            this.rebuildWidgets();
        });
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 22, DocAssets.DOCUMENTATION_TAB, this::onDocumentationClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.notebook")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 44, DocAssets.SPELL_STYLE_TAB, b -> ParticleOverviewScreen.openScreen(this, this.bookStack, this.selectedSpellSlot, this.hand)).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.spell_style")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 68, DocAssets.FAMILIAR_TAB, this::onFamiliarClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.familiar")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 92, DocAssets.SETTINGS_TAB, b -> Minecraft.getInstance().setScreen((Screen)new GuiSettingsScreen((Screen)this))).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.settings")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 116, DocAssets.DISCORD_TAB, b -> {
            try {
                Util.getPlatform().openUri(new URI("https://discord.com/invite/y7TMXZu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.discord")));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 6, true, this::onPageIncrease, true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 6, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.active = false;
        this.previousButton.visible = false;
        if (this.getExtraGlyphSlots() > 0) {
            this.nextGlyphButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 25, this.bookBottom - 26, true, i -> this.updateWindowOffset(this.spellWindowOffset + 1), true));
            this.prevGlyphButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft, this.bookBottom - 26, false, i -> this.updateWindowOffset(this.spellWindowOffset - 1), true));
            this.updateWindowOffset(0);
        }
        this.validate();
    }

    public int getNumPages() {
        return (int)Math.ceil((double)this.displayedGlyphs.size() / 58.0);
    }

    private void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        int perRow = 6;
        int maxRows = 7;
        List<AbstractSpellPart> sorted = new ArrayList<AbstractSpellPart>(this.displayedGlyphs);
        sorted.sort(Comparator.comparingInt(p -> {
            AbstractSpellPart abstractSpellPart = p;
            Objects.requireNonNull(abstractSpellPart);
            AbstractSpellPart selector0$temp = abstractSpellPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractAugment.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    AbstractAugment ignored = (AbstractAugment)selector0$temp;
                    yield 3;
                }
                default -> p.getTypeIndex();
            };
        }).thenComparing(AbstractSpellPart::getLocaleName));
        sorted = sorted.subList(84 * page, Math.min(sorted.size(), 84 * (page + 1)));
        int count = 0;
        for (AbstractSpellPart part : sorted) {
            boolean isNextPage = count >= perRow * maxRows;
            int numRows = count / perRow;
            if (isNextPage) {
                numRows = (count - perRow * maxRows) / perRow;
            }
            GlyphButton cell = new GlyphButton(this.bookLeft + 20 + (isNextPage ? 134 : 0) + count % perRow * 20, numRows * 18 + this.bookTop + 20, part, this::onGlyphClick);
            this.addRenderableWidget((GuiEventListener)cell);
            this.glyphButtons.add(cell);
            ++count;
        }
    }

    public void onSearchChanged(String str) {
        if (str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.setSuggestion("");
            this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : this.unlockedSpells) {
                if (!spellPart.getLocaleName().toLowerCase().contains(str.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Renderable w : this.renderables) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton)) continue;
                GlyphButton glyphButton = (GlyphButton)w;
                if (glyphButton.abstractSpellPart.getRegistryName() == null || (part = GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName())) == null) continue;
                glyphButton.visible = part.getLocaleName().toLowerCase().contains(str.toLowerCase());
            }
        } else {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.unlockedSpells;
            for (Renderable w : this.renderables) {
                if (!(w instanceof GlyphButton)) continue;
                ((GlyphButton)w).visible = true;
            }
        }
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < this.glyphsPerPage) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        } else {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
    }

    public void onPageIncrease(Button button) {
        if (this.page + 1 >= this.getNumPages()) {
            return;
        }
        ++this.page;
        if (this.displayedGlyphs.size() < this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        }
        this.previousButton.active = true;
        this.previousButton.visible = true;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onPageDec(Button button) {
        if (this.page <= 0) {
            this.page = 0;
            return;
        }
        --this.page;
        if (this.page == 0) {
            this.previousButton.active = false;
            this.previousButton.visible = false;
        }
        if (this.displayedGlyphs.size() > this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public int getExtraGlyphSlots() {
        return ((Boolean)ServerConfig.INFINITE_SPELLS.get() != false ? (Integer)ServerConfig.INF_SPELLS_LENGHT_MODIFIER.get() : 0) + this.bonusSlots;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        boolean isShiftDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue());
        if (this.getExtraGlyphSlots() > 0 && isShiftDown) {
            if (pScrollY < 0.0 && this.nextGlyphButton.active) {
                this.updateWindowOffset(this.spellWindowOffset + 1);
            } else if (pScrollY > 0.0 && this.prevGlyphButton.active) {
                this.updateWindowOffset(this.spellWindowOffset - 1);
            }
            return true;
        }
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollY < 0.0 && this.nextButton.active) {
            this.onPageIncrease((Button)this.nextButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollY > 0.0 && this.previousButton.active) {
            this.onPageDec((Button)this.previousButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void onDocumentationClick(Button button) {
        GuiUtils.openWiki(ArsNouveau.proxy.getPlayer());
    }

    public void onFamiliarClick(Button button) {
        Collection familiarHolders = new ArrayList();
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)ArsNouveau.proxy.getPlayer());
        if (cap != null) {
            familiarHolders = cap.getUnlockedFamiliars().stream().map(s -> s.familiarHolder.getRegistryName()).collect(Collectors.toList());
        }
        ArrayList finalFamiliarHolders = familiarHolders;
        Minecraft.getInstance().setScreen((Screen)new GuiFamiliarScreen(FamiliarRegistry.getFamiliarHolderMap().values().stream().filter(f -> finalFamiliarHolders.contains(f.getRegistryName())).collect(Collectors.toList()), (Screen)this));
    }

    public void onCraftingSlotClick(Button button) {
        if (button instanceof CraftingButton) {
            CraftingButton craftingButton = (CraftingButton)button;
            craftingButton.clear();
            if (craftingButton.slotNum < this.spell.size()) {
                this.spell.set(craftingButton.slotNum, null);
            }
        }
        if (this.spell.stream().allMatch(Objects::isNull)) {
            this.spell.clear();
        }
        if (this.nextGlyphButton != null) {
            this.updateNextGlyphArrow();
        }
        this.validate();
    }

    public void onGlyphClick(Button button) {
        GlyphButton button1 = (GlyphButton)button;
        if (!button1.validationErrors.isEmpty()) {
            return;
        }
        for (CraftingButton b : this.craftingCells.subList(this.spellWindowOffset, Math.min(this.spellWindowOffset + 10, this.craftingCells.size()))) {
            if (b.getAbstractSpellPart() != null) continue;
            b.setAbstractSpellPart(button1.abstractSpellPart);
            if (b.slotNum >= this.spell.size()) {
                this.spell.add(button1.abstractSpellPart);
            } else {
                this.spell.set(b.slotNum, button1.abstractSpellPart);
            }
            if (this.nextGlyphButton != null) {
                this.updateNextGlyphArrow();
            }
            this.validate();
            return;
        }
    }

    private void updateNextGlyphArrow() {
        if (this.spellWindowOffset >= this.getExtraGlyphSlots() || this.spellWindowOffset > this.spell.size() - 1) {
            this.nextGlyphButton.active = false;
            this.nextGlyphButton.visible = false;
        } else {
            this.nextGlyphButton.active = true;
            this.nextGlyphButton.visible = true;
        }
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (pCodePoint >= '0' && pCodePoint <= '9') {
            int idx = Integer.parseInt(String.valueOf(pCodePoint));
            if (idx == 0) {
                idx = 10;
            }
            idx = idx - 1 + this.spellWindowOffset;
            Renderable renderable = this.hoveredWidget;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GlyphButton.class, CraftingButton.class}, (Object)renderable, n)) {
                case 0: {
                    GlyphButton button = (GlyphButton)renderable;
                    if (!button.validationErrors.isEmpty()) {
                        return true;
                    }
                    CraftingButton currentCell = this.craftingCells.get(idx);
                    currentCell.setAbstractSpellPart(button.abstractSpellPart);
                    for (int i = this.spell.size(); i <= idx; ++i) {
                        this.spell.add(null);
                    }
                    this.spell.set(idx, button.abstractSpellPart);
                    this.validate();
                    this.setFocused((GuiEventListener)button);
                    return true;
                }
                case 1: {
                    CraftingButton button = (CraftingButton)renderable;
                    for (int i = this.spell.size(); i <= Math.max(button.slotNum, idx); ++i) {
                        this.spell.add(null);
                    }
                    Collections.swap(this.spell, button.slotNum, idx);
                    int left = -1;
                    int right = -1;
                    for (CraftingButton cell : this.craftingCells) {
                        if (cell.slotNum == button.slotNum) {
                            left = cell.slotNum;
                        }
                        if (cell.slotNum == idx) {
                            right = cell.slotNum;
                        }
                        if (left == -1 || right == -1) continue;
                        break;
                    }
                    if (left == -1 || right == -1) {
                        return true;
                    }
                    Collections.swap(this.craftingCells, left, right);
                    this.craftingCells.get((int)left).slotNum = right;
                    this.craftingCells.get((int)right).slotNum = left;
                    this.validate();
                    this.setFocused((GuiEventListener)button);
                    return true;
                }
            }
        }
        if (super.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        if (!(this.searchBar.isFocused() && this.searchBar.active || System.currentTimeMillis() - this.timeOpened <= 30L)) {
            this.clearFocus();
            this.setFocused((GuiEventListener)this.searchBar);
            this.searchBar.active = true;
            this.searchBar.setValue("");
            this.searchBar.onClear.apply("");
            return this.searchBar.charTyped(pCodePoint, pModifiers);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(!GuiSpellBook.hasControlDown() || this.searchBar.isFocused() && this.searchBar.highlightPos != this.searchBar.value.length() || this.spellNameBox.isFocused() && this.spellNameBox.highlightPos != this.spellNameBox.value.length())) {
            if (GuiSpellBook.isCopy((int)keyCode)) {
                this.onCopyOrExport(null);
                return true;
            }
            if (GuiSpellBook.isPaste((int)keyCode)) {
                this.onPasteOrImport(null);
                return true;
            }
            if (GuiSpellBook.isCut((int)keyCode)) {
                this.onCopyOrExport(null);
                this.clear(null);
                return true;
            }
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!(keyCode == 341 || (keyCode >= 340 && keyCode <= 348 || this.searchBar.isFocused()) && this.searchBar.active)) {
            GuiEventListener prevFocus = this.getFocused();
            this.clearFocus();
            this.setFocused((GuiEventListener)this.searchBar);
            this.searchBar.active = true;
            if (!this.searchBar.keyPressed(keyCode, scanCode, modifiers)) {
                this.searchBar.active = false;
                this.clearFocus();
                this.setFocused(prevFocus);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Renderable renderable;
        if (button == 2 && (renderable = this.hoveredWidget) instanceof CraftingButton) {
            CraftingButton cell;
            int i;
            CraftingButton craftingCell = (CraftingButton)renderable;
            int idx = -1;
            int emptySpace = -1;
            for (i = 0; i < this.craftingCells.size(); ++i) {
                cell = this.craftingCells.get(i);
                if (cell.slotNum == craftingCell.slotNum) {
                    while (cell.getAbstractSpellPart() == null && i < this.craftingCells.size()) {
                        cell = this.craftingCells.get(++i);
                    }
                    idx = i;
                    continue;
                }
                if (idx == -1 || cell.getAbstractSpellPart() != null) continue;
                emptySpace = i;
                break;
            }
            if (idx == -1 || emptySpace == -1) {
                return true;
            }
            for (i = this.spell.size(); i <= emptySpace; ++i) {
                this.spell.add(null);
            }
            this.spell.remove(emptySpace);
            for (i = emptySpace; i >= idx + 1; --i) {
                cell = this.craftingCells.get(i);
                CraftingButton prev = this.craftingCells.get(i - 1);
                cell.setAbstractSpellPart(prev.getAbstractSpellPart());
            }
            this.spell.add(idx, null);
            this.craftingCells.get(idx).setAbstractSpellPart(null);
            this.setFocused((GuiEventListener)craftingCell);
            this.validate();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void resetCraftingCells() {
        int i;
        for (CraftingButton button : this.craftingCells) {
            this.removeWidget((GuiEventListener)button);
        }
        this.craftingCells = new ArrayList<CraftingButton>();
        for (i = 0; i < this.numLinks + this.getExtraGlyphSlots(); ++i) {
            CraftingButton cell = new CraftingButton(0, 0, this::onCraftingSlotClick, i);
            this.addRenderableWidget((GuiEventListener)cell);
            this.craftingCells.add(cell);
            cell.visible = false;
            AbstractSpellPart spellPart = i < this.spell.size() ? this.spell.get(i) : null;
            cell.setAbstractSpellPart(spellPart);
        }
        for (i = 0; i < 10; ++i) {
            int offset;
            int placementOffset = i % 10;
            int n = offset = placementOffset >= 5 ? 14 : 0;
            if (i + this.spellWindowOffset >= this.craftingCells.size()) break;
            CraftingButton cell = this.craftingCells.get(this.spellWindowOffset + i);
            cell.setX(this.bookLeft + 19 + 24 * placementOffset + offset);
            cell.setY(this.bookBottom - 43);
            cell.visible = true;
        }
    }

    public void updateWindowOffset(int offset) {
        int extraSlots = this.getExtraGlyphSlots();
        if (!(extraSlots <= 0 || this.spellWindowOffset == 0 && offset > 0 && this.spell.stream().allMatch(Objects::isNull))) {
            this.spellWindowOffset = Mth.clamp((int)offset, (int)0, (int)extraSlots);
            if (this.spellWindowOffset <= 0) {
                this.prevGlyphButton.active = false;
                this.prevGlyphButton.visible = false;
            } else {
                this.prevGlyphButton.active = true;
                this.prevGlyphButton.visible = true;
            }
            this.updateNextGlyphArrow();
        }
        this.validate();
    }

    public void clear(Button button) {
        boolean allWereEmpty = this.spell.isEmpty();
        this.spell.clear();
        if (allWereEmpty) {
            this.spellNameBox.setValue("");
        }
        this.validate();
    }

    protected void saveSpell() {
        this.validate();
        if (this.validationErrors.isEmpty()) {
            Spell spell = this.getSpell();
            Networking.sendToServer(new PacketUpdateCaster(spell, this.selectedSpellSlot, this.spellNameBox.getValue(), this.hand == InteractionHand.MAIN_HAND));
            ParticleOverviewScreen.LAST_SELECTED_PART = null;
        }
    }

    public static void open(InteractionHand hand) {
        ItemStack stack = Minecraft.getInstance().player.getItemInHand(hand);
        AbstractCaster<?> caster = SpellCasterRegistry.from(Minecraft.getInstance().player.getItemInHand(hand));
        if (lastOpenedScreen == null) {
            Minecraft.getInstance().setScreen((Screen)new GuiSpellBook(hand));
        } else {
            BaseBook baseBook = lastOpenedScreen;
            if (baseBook instanceof ParticleOverviewScreen) {
                ParticleOverviewScreen particleOverviewScreen = (ParticleOverviewScreen)baseBook;
                ParticleOverviewScreen.openScreen(particleOverviewScreen.previousScreen, stack, caster.getCurrentSlot(), hand);
            } else {
                Minecraft.getInstance().setScreen((Screen)new GuiSpellBook(hand));
            }
        }
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        int formOffset = 0;
        if (this.formTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.form").getString(), this.formTextRow > 6 ? 154 : 20, 5 + 18 * (this.formTextRow + (this.formTextRow == 1 ? 0 : 1)), -8355712, false);
            formOffset = 1;
        }
        if (this.effectTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.effect").getString(), this.effectTextRow > 6 ? 154 : 20, 5 + 18 * (this.effectTextRow % 7 + formOffset), -8355712, false);
        }
        if (this.augmentTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.augment").getString(), this.augmentTextRow > 6 ? 154 : 20, 5 + 18 * (this.augmentTextRow + formOffset), -8355712, false);
        }
        int manaLength = 96;
        manaLength = this.maxManaCache > 0 ? (int)Mth.clamp((float)((float)manaLength * ((float)(this.maxManaCache - this.currentCostCache) / (float)this.maxManaCache)), (float)-1.0f, (float)96.0f) : 0;
        int offsetLeft = 89;
        int yOffset = 210;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(1.2f, 1.2f, 1.2f);
        poseStack.translate(-25.0f, -30.0f, 0.0f);
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 18, 0.0f, 0.0f, 108, 18, 256, 256);
        int manaOffset = (int)(((float)ClientInfo.ticksInGame + partialTicks) / 3.0f % 33.0f) * 6;
        if (manaLength > 0) {
            graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_mana.png"), offsetLeft + 9, yOffset - 9, 0.0f, (float)manaOffset, manaLength, 6, 256, 256);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ArsNouveau.prefix("textures/gui/manabar_gui_grayscale.png"));
            RenderUtils.colorBlit(graphics.pose(), offsetLeft + 8, yOffset - 10, 0, manaOffset, 100, 8, 256, 256, manaLength < 0 ? Color.RED : Color.rainbowColor(ClientInfo.ticksInGame));
        }
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS && this.minecraft != null) {
            String text = this.currentCostCache + "  /  " + this.maxManaCache;
            int maxWidth = this.minecraft.font.width(this.maxManaCache + "  /  " + this.maxManaCache);
            int offset = offsetLeft - maxWidth / 2 + maxWidth - this.minecraft.font.width(text);
            graphics.drawString(this.minecraft.font, text, offset + 55, yOffset - 10, 0xFFFFFF, false);
        }
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 17, 0.0f, 18.0f, 108, 20, 256, 256);
        poseStack.popPose();
    }

    private int getCurrentManaCost() {
        Spell spell = this.getSpell();
        int cost = spell.getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)Minecraft.getInstance().player, spell, this.bookStack);
        return Math.max(cost, 0);
    }

    private void validate() {
        this.validate(this.spellValidator);
    }

    /*
     * WARNING - void declaration
     */
    private void validate(ISpellValidator validator) {
        AbstractSpellPart effect;
        this.resetCraftingCells();
        this.currentCostCache = this.getCurrentManaCost();
        this.maxManaCache = ManaUtil.getMaxMana((Player)Minecraft.getInstance().player);
        for (CraftingButton craftingButton : this.craftingCells) {
            craftingButton.validationErrors.clear();
        }
        List<SpellValidationError> errors = validator.validate(this.spell);
        for (SpellValidationError ve2 : errors) {
            CraftingButton b = this.craftingCells.get(ve2.getPosition());
            b.validationErrors.add(ve2);
        }
        this.validationErrors = errors;
        for (CraftingButton craftingButton : this.craftingCells) {
            craftingButton.setAugmenting(null);
        }
        Object var3_6 = null;
        for (int i = 0; i < Math.max(this.spell.size(), this.craftingCells.size()); ++i) {
            AbstractSpellPart part;
            AbstractSpellPart abstractSpellPart = part = i < this.spell.size() ? this.spell.get(i) : null;
            if (!(part instanceof AbstractAugment)) {
                AbstractSpellPart abstractSpellPart2 = part;
            }
            for (CraftingButton craftingButton : this.craftingCells) {
                void var3_7;
                if (craftingButton.slotNum != i) continue;
                craftingButton.setAugmenting((AbstractSpellPart)var3_7);
            }
        }
        AbstractSpellPart lastEffect = null;
        int lastGlyphNoGap = 0;
        int i = 0;
        while (i < this.spell.size() && (effect = this.spell.get(i)) != null) {
            if (!(effect instanceof AbstractAugment)) {
                lastEffect = effect;
            }
            lastGlyphNoGap = i++;
        }
        List<AbstractSpellPart> slicedSpell = this.spell.subList(0, this.spell.isEmpty() ? 0 : lastGlyphNoGap + 1);
        for (GlyphButton glyphButton : this.glyphButtons) {
            glyphButton.validationErrors.clear();
            glyphButton.augmentingParent = lastEffect;
            slicedSpell.add(GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName()));
            glyphButton.validationErrors.addAll(validator.validate(slicedSpell).stream().filter(ve -> ve.getPosition() >= slicedSpell.size() - 1).toList());
            slicedSpell.removeLast();
        }
    }

    @Override
    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        super.render(ms, mouseX, mouseY, partialTicks);
        this.hoveredWidget = null;
        for (Renderable widget : this.renderables) {
            AbstractWidget abstractWidget;
            if (!(widget instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, abstractWidget = (AbstractWidget)widget)) continue;
            this.hoveredWidget = widget;
            break;
        }
    }

    @Override
    protected TooltipComponent getClientImageTooltip(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            Object widget;
            if (renderable instanceof AbstractWidget && !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable)) continue;
            if (renderable instanceof GlyphButton) {
                widget = (GlyphButton)renderable;
                return widget.abstractSpellPart.spellSchools.isEmpty() ? null : new SchoolTooltip(widget.abstractSpellPart);
            }
            if (!(renderable instanceof GuiSpellSlot)) continue;
            GuiSpellSlot spellSlot = (GuiSpellSlot)renderable;
            if (spellSlot.isSelected) {
                if (this.spell.isEmpty()) {
                    return null;
                }
                return new SpellTooltip(this.getSpell(), false);
            }
            Spell spellInSlot = this.caster.getSpell(spellSlot.slotNum);
            if (spellInSlot.isEmpty()) {
                return null;
            }
            return new SpellTooltip(spellInSlot, false);
        }
        return null;
    }

    public void onCopyOrExport(Button ignoredB) {
        this.getMinecraft().keyboardHandler.setClipboard(this.getSpell().toBinaryBase64());
    }

    public void onPasteOrImport(Button ignoredB) {
        String clipboardString = Minecraft.getInstance().keyboardHandler.getClipboard();
        if (clipboardString.isEmpty()) {
            return;
        }
        Spell clipboard = Spell.fromBinaryBase64(clipboardString);
        if (!clipboard.isValid()) {
            return;
        }
        int maxSize = 10 + this.getExtraGlyphSlots();
        ArrayList<AbstractSpellPart> oldSpell = new ArrayList<AbstractSpellPart>(this.spell);
        Spell.Mutable clipSpell = Spell.fromBinaryBase64(clipboardString).mutable();
        this.spell = clipSpell.recipe.subList(0, Math.min(maxSize, clipSpell.recipe.size()));
        this.validate(this.pasteValidator);
        if (this.validationErrors.isEmpty()) {
            this.spell.removeIf(Objects::isNull);
            Networking.sendToServer(new PacketUpdateParticleTimeline(this.selectedSpellSlot, clipboard.particleTimeline(), this.hand == InteractionHand.MAIN_HAND));
            ParticleOverviewScreen.lastOpenedHash = 0;
            this.spellNameBox.setValue(clipboard.name());
            this.saveSpell();
        } else {
            this.spell = oldSpell;
        }
        this.validate(this.spellValidator);
    }

    protected Spell getSpell() {
        Spell.Mutable spell1 = new Spell(this.spell.stream().filter(Objects::nonNull).toList(), this.spellNameBox.getValue()).mutable();
        spell1.particleTimeline = this.caster.getParticles(this.selectedSpellSlot);
        return spell1.immutable();
    }
}

