/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.api.registry.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MobJarRenderer
implements BlockEntityRenderer<MobJarTile> {
    private final EntityRenderDispatcher entityRenderer;

    public MobJarRenderer(BlockEntityRendererProvider.Context pContext) {
        this.entityRenderer = pContext.getEntityRenderer();
    }

    public boolean shouldRender(MobJarTile blockEntity, Vec3 cameraPos) {
        return blockEntity.isVisible && super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(MobJarTile pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Entity entity = pBlockEntity.getEntity();
        if (entity == null) {
            return;
        }
        float f = 0.53125f;
        float f1 = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if ((double)f1 > 1.0) {
            f = (float)((double)f / ((double)f1 * 1.0));
        }
        if (entity instanceof LightningBolt) {
            LightningBolt bolt = (LightningBolt)entity;
            if (bolt.level.getGameTime() % 20L == 0L) {
                bolt.seed = ClientInfo.ticksInGame;
            }
            f = 0.0075f;
        }
        AtomicReference<Vec3> adjustedScale = new AtomicReference<Vec3>(new Vec3(0.0, 0.0, 0.0));
        AtomicReference<Vec3> adjustedTranslation = new AtomicReference<Vec3>(new Vec3(0.0, 0.0, 0.0));
        AtomicReference<Boolean> shouldParticlaTick = new AtomicReference<Boolean>(false);
        JarBehaviorRegistry.forEach(entity, jarBehavior -> {
            Vec3 customScale = jarBehavior.scaleOffset(pBlockEntity);
            adjustedScale.set(((Vec3)adjustedScale.get()).add(customScale));
            adjustedTranslation.set(((Vec3)adjustedTranslation.get()).add(jarBehavior.translate(pBlockEntity)));
            if (jarBehavior.shouldUsePartialTicks(pBlockEntity)) {
                shouldParticlaTick.set(true);
            }
        });
        Vec3 scale = new Vec3((double)f, (double)f, (double)f).multiply(adjustedScale.get().add(1.0, 1.0, 1.0));
        Vec3 translate = new Vec3(0.5, 0.0, 0.5).add(adjustedTranslation.get());
        pPoseStack.translate(translate.x, translate.y, translate.z);
        pPoseStack.scale((float)scale.x, (float)scale.y, (float)scale.z);
        Direction direction = (Direction)pBlockEntity.getBlockState().getValue((Property)MobJar.FACING);
        if (direction == Direction.EAST) {
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        } else if (direction == Direction.WEST) {
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (direction == Direction.NORTH) {
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (direction == Direction.SOUTH) {
            pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.DOWN) {
            pPoseStack.translate(0.0, (double)entity.getBbHeight() + 0.75, 0.0);
        }
        pPoseStack.mulPose(((Direction)pBlockEntity.getBlockState().getValue((Property)MobJar.FACING)).getRotation());
        entity.setDeltaMovement(0.0, 0.0, 0.0);
        if (shouldParticlaTick.get().booleanValue()) {
            entity.xo = entity.getX();
            entity.yo = entity.getY();
            entity.zo = entity.getZ();
            entity.xRotO = entity.xRot;
            entity.yRotO = entity.yRot;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.yBodyRotO = livingEntity.yBodyRot;
                livingEntity.yHeadRotO = livingEntity.yHeadRot;
            }
        } else {
            pPartialTick = 0.0f;
        }
        this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
        for (Entity entity1 : entity.getPassengers()) {
            this.entityRenderer.render(entity1, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
        }
    }
}

