/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.inv.CombinedHandlerInv;
import com.hollingsworth.arsnouveau.api.item.inv.FilterSet;
import com.hollingsworth.arsnouveau.api.item.inv.IMapInventory;
import com.hollingsworth.arsnouveau.common.block.tile.RepositoryCatalogTile;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ControllerInv
extends CombinedHandlerInv
implements IMapInventory {
    public RepositoryCatalogTile controllerTile;

    public ControllerInv(RepositoryCatalogTile controllerTile, IItemHandler ... itemHandler) {
        super(itemHandler);
        this.controllerTile = controllerTile;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        ItemStack remainder;
        IMapInventory connected;
        PriorityQueue<SortResult> validRepositories = this.preferredForStack(stack, false);
        for (SortResult connectedRepository : validRepositories) {
            connected = connectedRepository.mapInventory();
            if (connected == null || !connected.hasExistingSlotsForInsertion(stack)) continue;
            remainder = connected.insertStack(stack, simulate);
            if (remainder.isEmpty()) {
                return ItemStack.EMPTY;
            }
            stack = remainder;
        }
        for (SortResult connectedRepository : validRepositories) {
            connected = connectedRepository.mapInventory();
            if (connected == null || !connected.hasExistingSlotsForInsertion(ItemStack.EMPTY)) continue;
            remainder = connected.insertStack(stack, simulate);
            if (remainder.isEmpty()) {
                return ItemStack.EMPTY;
            }
            stack = remainder;
        }
        return stack;
    }

    @Override
    public boolean hasExistingSlotsForInsertion(ItemStack stack) {
        for (RepositoryCatalogTile.ConnectedRepository connectedRepository : this.controllerTile.connectedRepositories) {
            IMapInventory connected = (IMapInventory)connectedRepository.capability.getCapability();
            if (connected == null || !connected.hasExistingSlotsForInsertion(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack extractByItem(Item item, int count, boolean simulate, Predicate<ItemStack> filter) {
        for (RepositoryCatalogTile.ConnectedRepository connectedRepository : this.controllerTile.connectedRepositories) {
            ItemStack extracted;
            IMapInventory connected = (IMapInventory)connectedRepository.capability.getCapability();
            if (connected == null || (extracted = connected.extractByItem(item, count, simulate, filter)).isEmpty()) continue;
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public ItemScroll.SortPref getInsertionPreference(ItemStack stack) {
        PriorityQueue<SortResult> validRepositories = this.preferredForStack(stack, false);
        if (validRepositories.isEmpty()) {
            return ItemScroll.SortPref.INVALID;
        }
        return validRepositories.peek().mapInventory().getInsertionPreference(stack);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.insertStack(stack, simulate);
    }

    public PriorityQueue<SortResult> preferredForStack(ItemStack stack, boolean includeInvalid) {
        PriorityQueue<SortResult> filtered = new PriorityQueue<SortResult>(SortResult.comparator);
        if (!this.allowedByFilter(stack)) {
            return filtered;
        }
        for (RepositoryCatalogTile.ConnectedRepository connectedRepository : this.controllerTile.connectedRepositories) {
            BlockCapabilityCache<IMapInventory, Direction> cap = connectedRepository.capability;
            if (cap == null || cap.getCapability() == null) continue;
            ItemScroll.SortPref sortPref = ((IMapInventory)cap.getCapability()).getInsertionPreference(stack);
            if (!includeInvalid && sortPref == ItemScroll.SortPref.INVALID) continue;
            filtered.add(new SortResult(sortPref, connectedRepository));
        }
        return filtered;
    }

    public boolean allowedByFilter(ItemStack stack) {
        if (this.controllerTile.scrollStack.isEmpty() || stack.isEmpty()) {
            return true;
        }
        FilterSet.ListSet set = new FilterSet.ListSet();
        set.addFilterScroll(this.controllerTile.scrollStack, this);
        return set.getHighestPreference(stack) != ItemScroll.SortPref.INVALID;
    }

    public record SortResult(ItemScroll.SortPref sortPref, @NotNull RepositoryCatalogTile.ConnectedRepository connectedRepository) {
        public static Comparator<SortResult> comparator = Comparator.comparing(SortResult::sortPref, ItemScroll.sortPrefComparator.reversed());

        public BlockCapabilityCache<IMapInventory, Direction> capability() {
            return this.connectedRepository.capability;
        }

        public IMapInventory mapInventory() {
            return (IMapInventory)this.connectedRepository.capability.getCapability();
        }
    }
}

