/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MageBlockTile
extends ModdedTile
implements ITickable,
IDispellable,
IWololoable {
    int age;
    public boolean isPermanent;
    public double lengthModifier;
    public ParticleColor color = ParticleColor.defaultParticleColor();

    public MageBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.MAGE_BLOCK_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.isPermanent) {
            return;
        }
        if (!this.level.isClientSide) {
            ++this.age;
            if ((double)this.age > 300.0 + 100.0 * this.lengthModifier) {
                this.level.destroyBlock(this.getBlockPos(), false);
                this.level.removeBlockEntity(this.getBlockPos());
            }
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 8);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.age = compound.getInt("age");
        this.color = ParticleColorRegistry.from(compound.getCompound("lightColor"));
        this.isPermanent = compound.getBoolean("permanent");
        this.lengthModifier = compound.getDouble("modifier");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("age", (Tag)IntTag.valueOf((int)this.age));
        tag.put("lightColor", (Tag)this.color.serialize());
        tag.putBoolean("permanent", this.isPermanent);
        tag.putDouble("modifier", this.lengthModifier);
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        this.level.destroyBlock(this.getBlockPos(), false);
        this.level.removeBlockEntity(this.getBlockPos());
        return true;
    }

    @Override
    public void setColor(ParticleColor color) {
        this.color = color;
        this.updateBlock();
    }

    @Override
    public ParticleColor getColor() {
        return this.color;
    }
}

