/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class AlakarkinosRecipeProvider
extends SimpleDataProvider {
    public List<Wrapper> recipes = new ArrayList<Wrapper>();

    public AlakarkinosRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (Wrapper recipe : this.recipes) {
            Path path = AlakarkinosRecipeProvider.getRecipePath(this.output, recipe.location().getPath());
            this.saveStable(pOutput, ANCodecs.toJson(AlakarkinosRecipe.CODEC, recipe.recipe), path);
        }
    }

    protected void addEntries() {
        this.recipes.add(new Wrapper(ArsNouveau.prefix("desert_well"), new AlakarkinosRecipe(Blocks.SAND, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_WELL_ARCHAEOLOGY, 100)));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("desert_pyramid"), new AlakarkinosRecipe(Blocks.SAND, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, 25)));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("ocean_ruins_warm"), new AlakarkinosRecipe(Blocks.SAND, (ResourceKey<LootTable>)BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY, 25)));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("ocean_ruins_cold"), new AlakarkinosRecipe(Blocks.GRAVEL, (ResourceKey<LootTable>)BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY, 25)));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("trail_ruins_common"), new AlakarkinosRecipe(Blocks.GRAVEL, (ResourceKey<LootTable>)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 100)));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("trail_ruins_rare"), new AlakarkinosRecipe(Blocks.GRAVEL, (ResourceKey<LootTable>)BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE, 25)));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/alakarkinos/" + id + ".json");
    }

    public String getName() {
        return "Alakarkinos Recipe Datagen";
    }

    public record Wrapper(ResourceLocation location, AlakarkinosRecipe recipe) {
    }
}

