/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SummonRitualRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SummonRitualProvider
extends SimpleDataProvider {
    public List<SummonRitualRecipeWrapper> recipes = new ArrayList<SummonRitualRecipeWrapper>();

    public SummonRitualProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (SummonRitualRecipeWrapper recipe : this.recipes) {
            Path path = SummonRitualProvider.getRecipePath(this.output, recipe.id().getPath());
            this.saveStable(pOutput, (JsonElement)SummonRitualRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe.recipe()).getOrThrow(), path);
        }
    }

    protected void addEntries() {
        ArrayList<SummonRitualRecipe.WeightedMobType> bats = new ArrayList<SummonRitualRecipe.WeightedMobType>();
        bats.add(new SummonRitualRecipe.WeightedMobType(EntityType.getKey((EntityType)EntityType.BAT)));
        this.recipes.add(new SummonRitualRecipeWrapper(ArsNouveau.prefix("bats"), new SummonRitualRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}), SummonRitualRecipe.MobSource.MOB_LIST, 5, (WeightedRandomList<SummonRitualRecipe.WeightedMobType>)WeightedRandomList.create(bats))));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/summon_ritual/" + id + ".json");
    }

    public String getName() {
        return "Summon Ritual Datagen";
    }

    public static class SummonRitualRecipeWrapper {
        private final SummonRitualRecipe recipe;
        private final ResourceLocation id;

        public SummonRitualRecipeWrapper(ResourceLocation id, SummonRitualRecipe recipe) {
            this.recipe = recipe;
            this.id = id;
        }

        public SummonRitualRecipe recipe() {
            return this.recipe;
        }

        public ResourceLocation id() {
            return this.id;
        }
    }
}

