/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantedSkull
extends EnchantedFallingBlock {
    ItemStack renderStack;

    public EnchantedSkull(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    public EnchantedSkull(Level world, double v, double y, double v1, BlockState blockState) {
        super(world, v, y, v1, blockState);
    }

    public EnchantedSkull(Level world, BlockPos pos, BlockState blockState) {
        super(world, pos, blockState);
    }

    @Override
    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENCHANTED_HEAD_BLOCK.get();
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack pStack) {
        if (pStack.getItem() instanceof PlayerHeadItem && this.blockData != null) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)this.blockData.get("profile")).resultOrPartial().ifPresent(profile -> pStack.set(DataComponents.PROFILE, profile));
        }
        return this.spawnAtLocation(pStack, 0.0f);
    }

    public ItemStack getStack() {
        if (this.renderStack == null) {
            Item item = this.getBlockState().getBlock().asItem();
            ItemStack stack = item.getDefaultInstance();
            if (item instanceof PlayerHeadItem && this.blockData != null) {
                ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)this.blockData.get("profile")).resultOrPartial().ifPresent(profile -> stack.set(DataComponents.PROFILE, profile));
            }
            this.renderStack = stack;
        }
        return this.renderStack;
    }
}

