/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.CompleteCraftingGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindNextItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindPotionGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityWixie
extends AbstractFlyingCreature
implements GeoEntity,
IAnimationListener,
IDispellable,
ICharmSerializable {
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(EntityWixie.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public BlockPos cauldronPos;
    public int inventoryBackoff;
    AnimationController<?> summonController;
    AnimationController<?> castController;
    public static String[] COLORS = new String[]{"white", "green", "blue", "black", "red"};
    public static Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>();

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        if (this.getNavigation().isInProgress()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState castPredicate(AnimationState<P> event) {
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState summonPredicate(AnimationState<P> event) {
        return PlayState.CONTINUE;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "idleController", 20, this::idlePredicate));
        this.castController = new AnimationController((GeoAnimatable)this, "castController", 1, this::castPredicate);
        this.summonController = new AnimationController((GeoAnimatable)this, "summonController", 1, this::summonPredicate);
        animatableManager.add(this.castController);
        animatableManager.add(this.summonController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public EntityWixie(EntityType<? extends AbstractFlyingCreature> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    public EntityWixie(Level world, BlockPos pos) {
        this((EntityType<? extends AbstractFlyingCreature>)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), world);
        this.cauldronPos = pos;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(COLORS).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(COLOR, (Object)color.getName());
            player.getMainHandItem().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
        if (!(this.level.isClientSide || this.cauldronPos != null && this.level.getBlockEntity(this.cauldronPos) instanceof WixieCauldronTile)) {
            this.hurt(this.level.damageSources().playerAttack((Player)ANFakePlayer.getPlayer((ServerLevel)this.level)), 99.0f);
        }
        if (!this.level.isClientSide && this.inventoryBackoff > 0) {
            --this.inventoryBackoff;
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FindNextItemGoal(this));
        this.goalSelector.addGoal(2, (Goal)new FindPotionGoal(this));
        this.goalSelector.addGoal(1, (Goal)new CompleteCraftingGoal(this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(COLOR, (Object)"blue");
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.FLYING_SPEED, ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("summoner_x")) {
            this.cauldronPos = new BlockPos(tag.getInt("summoner_x"), tag.getInt("summoner_y"), tag.getInt("summoner_z"));
        }
        if (tag.contains("color")) {
            this.entityData.set(COLOR, (Object)tag.getString("color"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.cauldronPos != null) {
            tag.putInt("summoner_x", this.cauldronPos.getX());
            tag.putInt("summoner_y", this.cauldronPos.getY());
            tag.putInt("summoner_z", this.cauldronPos.getZ());
        }
        if (this.entityData.get(COLOR) != null) {
            tag.putString("color", (String)this.entityData.get(COLOR));
        }
    }

    @Override
    public void startAnimation(int arg) {
        if (arg == Animations.CAST.ordinal() && this.castController != null) {
            this.castController.forceAnimationReset();
            this.castController.setAnimation(RawAnimation.begin().thenPlay("cast"));
        } else if (arg == Animations.SUMMON_ITEM.ordinal() && this.summonController != null) {
            this.summonController.forceAnimationReset();
            this.summonController.setAnimation(RawAnimation.begin().thenPlay("summon_item"));
        }
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        if (!level.isClientSide) {
            ItemStack stack = new ItemStack(ItemsRegistry.WIXIE_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            level.addFreshEntity((Entity)new ItemEntity((Level)level, this.getX(), this.getY(), this.getZ(), stack));
        }
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide) {
            ItemStack stack = new ItemStack(ItemsRegistry.WIXIE_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack.copy()));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public ResourceLocation getTexture() {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        String finalColor = color;
        return TEXTURES.computeIfAbsent(color, k -> ArsNouveau.prefix("textures/entity/wixie_" + finalColor + ".png"));
    }

    @Override
    public void fromCharmData(PersistentFamiliarData data) {
        this.entityData.set(COLOR, (Object)data.color());
        this.setCustomName(data.name());
    }

    @Override
    public String getColor() {
        return (String)this.getEntityData().get(COLOR);
    }

    public static enum Animations {
        CAST,
        SUMMON_ITEM;

    }
}

