/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.BurstTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectReset;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectBurst
extends AbstractEffect {
    public static final EffectBurst INSTANCE = new EffectBurst();

    public EffectBurst() {
        super(GlyphLib.EffectBurstID, "Burst");
        EffectReset.RESET_LIMITS.add(this);
    }

    @Override
    public String getBookDescription() {
        return "Resolves the spell in a spherical area around the target. Augment with Sensitive to target blocks instead of entities and Dampen to make an empty sphere. Augment with AOE to increase the radius. ";
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.makeSphere(rayTraceResult.getBlockPos(), world, shooter, spellStats, spellContext, resolver);
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.makeSphere(rayTraceResult.getEntity().blockPosition(), world, shooter, spellStats, spellContext, resolver);
    }

    public void makeSphere(BlockPos center, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Predicate<Double> sphere;
        if (spellContext.getRemainingSpell().isEmpty()) {
            return;
        }
        int radius = (int)spellStats.getAoeMultiplier() + (spellStats.isSensitive() ? 1 : 3);
        Predicate<Double> predicate = sphere = spellStats.hasBuff(AugmentDampen.INSTANCE) ? distance -> distance <= (double)radius + 0.5 && distance >= (double)radius - 0.5 : distance -> distance <= (double)radius + 0.5;
        if (spellStats.isSensitive()) {
            for (BlockPos pos : BlockPos.withinManhattan((BlockPos)center, (int)radius, (int)radius, (int)radius)) {
                if (!sphere.test(BlockUtil.distanceFromCenter(pos, center))) continue;
                pos = pos.immutable();
                SpellResolver resolver1 = resolver.getNewResolver(spellContext.clone().makeChildContext());
                resolver1.onResolveEffect(world, (HitResult)new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Direction.UP, pos, false));
                ParticleEmitter emitter = this.resolveEmitter(spellContext, pos.getCenter());
                emitter.tick(world);
            }
        } else {
            for (Entity entity : world.getEntities(null, new AABB(center).inflate((double)radius, (double)radius, (double)radius))) {
                if (!(entity instanceof LivingEntity) && !entity.getType().is(EntityTags.BURST_WHITELIST) || !sphere.test(BlockUtil.distanceFromCenter(entity.blockPosition(), center))) continue;
                SpellResolver resolver1 = resolver.getNewResolver(spellContext.clone().makeChildContext());
                resolver1.onResolveEffect(world, (HitResult)new EntityHitResult(entity));
                ParticleEmitter emitter = this.resolveEmitter(spellContext, entity.position.add(0.0, (double)entity.getBbHeight() / 2.0, 0.0));
                emitter.tick(world);
            }
        }
        this.playResolveSound(spellContext, world, center.getCenter());
        spellContext.setCanceled(true);
    }

    public ParticleEmitter resolveEmitter(SpellContext spellContext, Vec3 position) {
        TimelineEntryData entryData = ((BurstTimeline)spellContext.getParticleTimeline((IParticleTimelineType)ParticleTimelineRegistry.BURST_TIMELINE.get())).onResolvingEffect;
        return this.createStaticEmitter(entryData, position);
    }

    public void playResolveSound(SpellContext spellContext, Level level, Vec3 position) {
        ((BurstTimeline)spellContext.getParticleTimeline((IParticleTimelineType)ParticleTimelineRegistry.BURST_TIMELINE.get())).resolveSound.sound.playSound(level, position.x, position.y, position.z);
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 1);
    }

    @Override
    public int getDefaultManaCost() {
        return 500;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put(AugmentAOE.INSTANCE, "Increases the target radius.");
        map.put(AugmentSensitive.INSTANCE, "Targets blocks instead of entities.");
        map.put(AugmentDampen.INSTANCE, "Targets an empty sphere.");
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentSensitive.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.add(EffectLinger.INSTANCE.getRegistryName());
        defaults.add(EffectWall.INSTANCE.getRegistryName());
    }
}

