/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.codecs.FieldsConsumer;
import org.apache.lucene.ars_nouveau.codecs.FieldsProducer;
import org.apache.lucene.ars_nouveau.codecs.PostingsFormat;
import org.apache.lucene.ars_nouveau.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter;
import org.apache.lucene.ars_nouveau.index.SegmentReadState;
import org.apache.lucene.ars_nouveau.index.SegmentWriteState;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.IDVersionPostingsReader;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.IDVersionPostingsWriter;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.VersionBlockTreeTermsReader;
import org.apache.lucene.ars_nouveau.sandbox.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.ars_nouveau.util.BitUtil;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.IOUtils;

public class IDVersionPostingsFormat
extends PostingsFormat {
    public static final long MIN_VERSION = 0L;
    public static final long MAX_VERSION = 0x3FFFFFFFFFFFFFFFL;
    private final int minTermsInBlock;
    private final int maxTermsInBlock;

    public IDVersionPostingsFormat() {
        this(25, 48);
    }

    public IDVersionPostingsFormat(int minTermsInBlock, int maxTermsInBlock) {
        super("IDVersion");
        this.minTermsInBlock = minTermsInBlock;
        this.maxTermsInBlock = maxTermsInBlock;
        Lucene90BlockTreeTermsWriter.validateSettings(minTermsInBlock, maxTermsInBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        VersionBlockTreeTermsWriter versionBlockTreeTermsWriter;
        block3: {
            IDVersionPostingsWriter postingsWriter = new IDVersionPostingsWriter(state.liveDocs);
            boolean success = false;
            try {
                VersionBlockTreeTermsWriter ret = new VersionBlockTreeTermsWriter(state, postingsWriter, this.minTermsInBlock, this.maxTermsInBlock);
                success = true;
                versionBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return versionBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        VersionBlockTreeTermsReader versionBlockTreeTermsReader;
        block3: {
            IDVersionPostingsReader postingsReader = new IDVersionPostingsReader();
            boolean success = false;
            try {
                VersionBlockTreeTermsReader ret = new VersionBlockTreeTermsReader(postingsReader, state);
                success = true;
                versionBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return versionBlockTreeTermsReader;
    }

    public static long bytesToLong(BytesRef bytes) {
        return BitUtil.VH_BE_LONG.get(bytes.bytes, bytes.offset);
    }

    public static void longToBytes(long v, BytesRef bytes) {
        if (v > 0x3FFFFFFFFFFFFFFFL || v < 0L) {
            throw new IllegalArgumentException("version must be >= MIN_VERSION=0 and <= MAX_VERSION=4611686018427387903 (got: " + v + ")");
        }
        bytes.offset = 0;
        bytes.length = 8;
        BitUtil.VH_BE_LONG.set(bytes.bytes, 0, v);
        assert (IDVersionPostingsFormat.bytesToLong(bytes) == v) : IDVersionPostingsFormat.bytesToLong(bytes) + " vs " + v + " bytes=" + String.valueOf(bytes);
    }
}

