/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.curios.wolffangnecklace;

import com.craftyeddie.thenorthwildhunt.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class WolfFangNecklaceTicker {
    private static final ResourceLocation DAMAGE_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"wolf_fang_necklace_damage");

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (WolfFangNecklaceTicker.hasNecklaceEquipped(player)) {
            WolfFangNecklaceTicker.applyPredatorsInstinct(player);
        } else {
            WolfFangNecklaceTicker.removePredatorsInstinct(player);
        }
    }

    private static boolean hasNecklaceEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inv -> inv.getStacksHandler("necklace")).map(handler -> {
            IDynamicStackHandler stacks = handler.getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                ItemStack s = stacks.getStackInSlot(i);
                if (s.isEmpty() || !s.is(ModItems.WOLF_FANG_NECKLACE.get())) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static void applyPredatorsInstinct(Player player) {
        double maxHealth = player.getMaxHealth();
        double currentHealth = player.getHealth();
        double bonusDamage = currentHealth <= maxHealth / 2.0 ? 4.0 : 2.0;
        AttributeInstance attr = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attr != null) {
            attr.getModifiers().stream().filter(mod -> mod.id().equals((Object)DAMAGE_BOOST_ID)).findFirst().ifPresent(arg_0 -> ((AttributeInstance)attr).removeModifier(arg_0));
            AttributeModifier modifier = new AttributeModifier(DAMAGE_BOOST_ID, bonusDamage, AttributeModifier.Operation.ADD_VALUE);
            attr.addTransientModifier(modifier);
        }
    }

    private static void removePredatorsInstinct(Player player) {
        AttributeInstance attr = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attr != null) {
            attr.getModifiers().stream().filter(mod -> mod.id().equals((Object)DAMAGE_BOOST_ID)).findFirst().ifPresent(arg_0 -> ((AttributeInstance)attr).removeModifier(arg_0));
        }
    }
}

