/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.entity.client;

import com.craftyeddie.thenorthwildhunt.entity.client.WolfFangSpearModel;
import com.craftyeddie.thenorthwildhunt.entity.custom.WolfFangSpearEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WolfFangSpearRenderer
extends GeoEntityRenderer<WolfFangSpearEntity> {
    private static final float MODEL_YAW_OFFSET = 180.0f;
    private static final float MODEL_PITCH_OFFSET = 0.0f;

    public WolfFangSpearRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new WolfFangSpearModel());
        this.shadowRadius = 0.2f;
    }

    public void preRender(PoseStack poseStack, WolfFangSpearEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int packedColor) {
        float yaw = animatable.getYRot();
        float pitch = animatable.getXRot();
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw + 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch + 0.0f));
        if (animatable.isGrounded() && animatable.groundedOffset != null) {
            poseStack.mulPose(Axis.XP.rotationDegrees(animatable.groundedOffset.x));
            poseStack.mulPose(Axis.YP.rotationDegrees(animatable.groundedOffset.y));
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, packedColor);
    }
}

