/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.entity.custom;

import com.craftyeddie.thenorthwildhunt.entity.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MooseEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_FEMALE = SynchedEntityData.defineId(MooseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.moose.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.moose.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.moose.run");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.moose.attack");

    public MooseEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_FEMALE, (Object)false);
    }

    public boolean isFemale() {
        return (Boolean)this.entityData.get(IS_FEMALE);
    }

    public void setFemale(boolean female) {
        this.entityData.set(IS_FEMALE, (Object)female);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, reason, spawnData);
        this.setFemale(this.random.nextBoolean());
        return data;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsFemale", this.isFemale());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("IsFemale")) {
            this.setFemale(tag.getBoolean("IsFemale"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ARMOR, 2.0);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"entities/moose"));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        if (this.isFemale()) {
            this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.6, 2.0));
        } else {
            this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.6, true));
        }
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        if (!this.isFemale()) {
            this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.targetSelector.addGoal(2, (Goal)new DefendFemalesGoal(this));
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        if (this.isFemale()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GOAT_SCREAMING_HURT, this.getSoundSource(), 2.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    protected float getSoundVolume() {
        return 1.2f;
    }

    public float getVoicePitch() {
        return 0.4f;
    }

    public boolean canMate(Animal other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof MooseEntity)) {
            return false;
        }
        MooseEntity moose = (MooseEntity)other;
        return this.isFemale() != moose.isFemale();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob partner) {
        MooseEntity baby = (MooseEntity)((EntityType)ModEntities.MOOSE.get()).create((Level)serverLevel);
        if (baby != null) {
            baby.setFemale(serverLevel.random.nextBoolean());
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "controller", 2, this::animationPredicate);
        main.triggerableAnim("attack", ATTACK);
        controllers.add(main);
    }

    private PlayState animationPredicate(AnimationState<MooseEntity> state) {
        boolean isMoving;
        double horizontalSpeed = this.getDeltaMovement().horizontalDistanceSqr();
        boolean bl = isMoving = horizontalSpeed > 0.01 || this.getNavigation().isInProgress();
        if (isMoving) {
            if (horizontalSpeed > 0.04) {
                state.setAndContinue(RUN);
            } else {
                state.setAndContinue(WALK);
            }
        } else {
            state.setAndContinue(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public boolean doHurtTarget(Entity target) {
        boolean flag = super.doHurtTarget(target);
        if (flag && target instanceof LivingEntity) {
            this.triggerAnim("controller", "attack");
        }
        return flag;
    }

    static class DefendFemalesGoal
    extends TargetGoal {
        private final MooseEntity moose;
        private LivingEntity target;

        public DefendFemalesGoal(MooseEntity moose) {
            super((Mob)moose, false, true);
            this.moose = moose;
        }

        public boolean canUse() {
            if (this.moose.isFemale()) {
                return false;
            }
            double radius = 16.0;
            for (MooseEntity nearby : this.moose.level().getEntitiesOfClass(MooseEntity.class, this.moose.getBoundingBox().inflate(radius))) {
                if (!nearby.isFemale() || nearby.getLastHurtByMob() == null) continue;
                this.target = nearby.getLastHurtByMob();
                return true;
            }
            return false;
        }

        public void start() {
            this.mob.setTarget(this.target);
            super.start();
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && this.mob.getTarget() == this.target;
        }
    }
}

