/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.item;

import com.craftyeddie.thenorthwildhunt.entity.custom.TimberWolfEntity;
import com.craftyeddie.thenorthwildhunt.entity.custom.WolfFangSpearEntity;
import com.craftyeddie.thenorthwildhunt.item.WolfFangDataComponents;
import com.craftyeddie.thenorthwildhunt.item.client.WolfFangSpearItemRenderer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class WolfFangSpearItem
extends Item {
    private final ItemAttributeModifiers defaultModifiers = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(WolfFangSpearItem.id("spear_attack_damage"), 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(WolfFangSpearItem.id("spear_attack_speed"), 1.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(WolfFangSpearItem.id("spear_attack_reach"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();

    public WolfFangSpearItem(Item.Properties props) {
        super(props.stacksTo(1).durability(250));
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)path);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return stack.is((Item)this) ? this.defaultModifiers : super.getDefaultAttributeModifiers(stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charge = this.getUseDuration(stack, entity) - timeLeft;
        float velocity = WolfFangSpearItem.getPowerForTime(charge);
        if (velocity < 0.1f) {
            return;
        }
        if (!level.isClientSide) {
            WolfFangSpearEntity spear = new WolfFangSpearEntity(level, player, stack);
            spear.shootFromPlayer(player, velocity * 3.0f, 1.0f);
            level.addFreshEntity((Entity)spear);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 0.5f);
            if (!player.getAbilities().instabuild) {
                player.getInventory().removeItem(stack);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        if ((target instanceof Wolf || target instanceof TimberWolfEntity) && target.isDeadOrDying()) {
            int kills = (Integer)stack.getOrDefault(WolfFangDataComponents.WOLF_KILLS, (Object)0) + 1;
            stack.set(WolfFangDataComponents.WOLF_KILLS, (Object)kills);
            if (kills >= 25) {
                ResourceKey wolfSlayerKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"wolf_slayer"));
                player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(wolfSlayerKey).ifPresent(holder -> {
                    EnchantmentHelper.updateEnchantments((ItemStack)stack, ench -> ench.set((Holder)holder, 1));
                    stack.set(WolfFangDataComponents.WOLF_KILLS, (Object)0);
                    player.displayClientMessage((Component)Component.literal((String)"Your spear gained Wolf Slayer!"), true);
                });
            }
        }
        ResourceKey wolfSlayerKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"wolf_slayer"));
        int level = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(wolfSlayerKey).map(holder -> EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)stack)).orElse(0);
        if (level > 0 && (target instanceof Wolf || target instanceof TimberWolfEntity)) {
            float extraDamage = 12.0f * (float)level;
            target.hurt(player.damageSources().playerAttack(player), extraDamage);
        }
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && entity instanceof Player) {
            Player player = (Player)entity;
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.LOYALTY) || enchantment.is(Enchantments.PIERCING) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.SHARPNESS);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private final BlockEntityWithoutLevelRenderer renderer = new WolfFangSpearItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

