/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.registry.ModCapabilities;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DismountDragonPacket
extends AbstractMessage<DismountDragonPacket> {
    private static final StreamCodec<FriendlyByteBuf, DismountDragonPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DismountDragonPacket::getEntityId, (StreamCodec)ByteBufCodecs.BOOL, DismountDragonPacket::isState, DismountDragonPacket::new);
    private final int entityId;
    private final boolean state;

    DismountDragonPacket() {
        this.entityId = -1;
        this.state = false;
    }

    public DismountDragonPacket(int entityId, boolean state) {
        this.entityId = entityId;
        this.state = state;
    }

    @Override
    protected String getTypeName() {
        return "dismount_dragon";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DismountDragonPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean autoSync() {
        return true;
    }

    @Override
    public void handle(IPayloadContext supplier, Player player) {
        Level level = player.level;
        Entity entity = level.getEntity(this.entityId);
        if (entity instanceof Player) {
            Player player1 = (Player)entity;
            DragonOwnerCapability cap = (DragonOwnerCapability)player1.getData(ModCapabilities.PLAYER_CAPABILITY);
            cap.shouldDismount = this.state;
            if (this.state) {
                player1.stopRiding();
            }
        }
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public boolean isState() {
        return this.state;
    }
}

