/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.util.PlayerStateUtils;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonNBTSync
extends AbstractMessage<DragonNBTSync> {
    private static final StreamCodec<FriendlyByteBuf, DragonNBTSync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonNBTSync::getId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, DragonNBTSync::getTag, DragonNBTSync::new);
    private final int id;
    private final CompoundTag tag;

    DragonNBTSync() {
        this.id = -1;
        this.tag = new CompoundTag();
    }

    public DragonNBTSync(int id, CompoundTag tag) {
        this.id = id;
        this.tag = tag != null ? tag : new CompoundTag();
    }

    @Override
    protected String getTypeName() {
        return "whistle_data_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonNBTSync> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
    }

    @Override
    public void handleClient(IPayloadContext context, Player player) {
        DragonOwnerCapability state = PlayerStateUtils.getHandler(player);
        if (this.tag.isEmpty()) {
            state.dragonNBTs.remove(this.id);
            return;
        }
        state.dragonNBTs.put(this.id, this.tag);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public CompoundTag getTag() {
        return this.tag;
    }
}

