/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.DragonBreed;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.BreedingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;

public class DragonBreedsRegistry {
    private static final HashMap<String, IDragonBreed> DRAGON_TYPES = new HashMap();

    public static void register(IDragonBreed breed) {
        DRAGON_TYPES.put(breed.getId(), breed);
    }

    public static void registerHybrids() {
        Stream<String> list = DRAGON_TYPES.entrySet().stream().filter(ent -> ent.getValue() instanceof DragonHybridBreed).map(Map.Entry::getKey);
        list.forEach(DRAGON_TYPES::remove);
        List<IDragonBreed> breeds = DragonBreedsRegistry.getDragonBreeds();
        for (IDragonBreed dragonBreed1 : breeds) {
            for (IDragonBreed dragonBreed2 : breeds) {
                if (dragonBreed1 == dragonBreed2 || dragonBreed1.getDragonModelLocation() != dragonBreed2.getDragonModelLocation()) continue;
                DragonBreedsRegistry.registerHybrid(dragonBreed1, dragonBreed2);
            }
        }
    }

    public static void registerHybrid(IDragonBreed parent1, IDragonBreed parent2) {
        DragonBreedsRegistry.register(new DragonHybridBreed(parent1, parent2));
    }

    public static void setBreeds(List<IDragonBreed> breeds) {
        DRAGON_TYPES.clear();
        for (IDragonBreed breed : breeds) {
            DragonBreedsRegistry.register(breed);
        }
    }

    public static IDragonBreed getDragonBreed(String name) {
        IDragonBreed val = DRAGON_TYPES.getOrDefault(name, null);
        return val == null ? DragonBreedsRegistry.getDefault() : val;
    }

    public static IDragonBreed getHybridBreed(IDragonBreed breed1, IDragonBreed breed2) {
        return DragonBreedsRegistry.getDragonBreed("hybrid_" + breed1.getId() + "_" + breed2.getId());
    }

    public static boolean hasDragonBreed(String name) {
        return DRAGON_TYPES.containsKey(name);
    }

    public static List<IDragonBreed> getDragonBreeds() {
        return new ArrayList<IDragonBreed>(DRAGON_TYPES.values());
    }

    public static IDragonBreed getFirst() {
        return DragonBreedsRegistry.getDragonBreeds().stream().findFirst().orElse(new DragonBreed());
    }

    public static IDragonBreed getDefault() {
        return DragonBreedsRegistry.hasDragonBreed("end") ? DragonBreedsRegistry.getDragonBreed("end") : DragonBreedsRegistry.getFirst();
    }

    public static ArrayList<IDragonBreed> getEggOutcomes(TameableDragonEntity tameableDragonEntity, ServerLevel level, TameableDragonEntity mate) {
        ArrayList<IDragonBreed> eggOutcomes = new ArrayList<IDragonBreed>();
        eggOutcomes.addAll(DragonBreedsRegistry.getBreeds(tameableDragonEntity));
        eggOutcomes.addAll(DragonBreedsRegistry.getBreeds(mate));
        if (ServerConfig.HABITAT_OFFSPRING) {
            IDragonBreed highestBreed1 = BreedingUtils.getHabitatBreedOutcome(level, tameableDragonEntity.blockPosition());
            IDragonBreed highestBreed2 = BreedingUtils.getHabitatBreedOutcome(level, mate.blockPosition());
            if (highestBreed1 != null && !eggOutcomes.contains(highestBreed1)) {
                eggOutcomes.add(highestBreed1);
            }
            if (highestBreed2 != null && !eggOutcomes.contains(highestBreed2)) {
                eggOutcomes.add(highestBreed2);
            }
        }
        if (ServerConfig.ALLOW_HYBRIDIZATION) {
            ArrayList<IDragonBreed> newList = new ArrayList<IDragonBreed>();
            for (IDragonBreed breed1 : eggOutcomes) {
                for (IDragonBreed breed2 : eggOutcomes) {
                    IDragonBreed hybrid;
                    if (breed1 == breed2 || (hybrid = DragonBreedsRegistry.getHybridBreed(breed1, breed2)) == null) continue;
                    newList.add(hybrid);
                }
            }
            eggOutcomes.addAll(newList);
        }
        return eggOutcomes;
    }

    public static List<IDragonBreed> getBreeds(TameableDragonEntity tameableDragonEntity) {
        ArrayList<IDragonBreed> breeds = new ArrayList<IDragonBreed>();
        IDragonBreed iDragonBreed = tameableDragonEntity.getBreed();
        if (iDragonBreed instanceof DragonHybridBreed) {
            DragonHybridBreed hybridBreed = (DragonHybridBreed)iDragonBreed;
            breeds.add(hybridBreed.parent1);
            breeds.add(hybridBreed.parent2);
            return breeds;
        }
        breeds.add(tameableDragonEntity.getBreed());
        return breeds;
    }
}

