/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.packets.CompleteDataSync;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="dmr", bus=EventBusSubscriber.Bus.GAME)
public class ModCapabilities {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"dmr");
    public static Supplier<AttachmentType<DragonOwnerCapability>> PLAYER_CAPABILITY = ATTACHMENT_TYPES.register("dragon_owner", () -> AttachmentType.serializable(DragonOwnerCapability::new).copyOnDeath().build());

    @SubscribeEvent
    public static void onLoggedIn(PlayerEvent.PlayerLoggedInEvent loggedInEvent) {
        Player player = loggedInEvent.getEntity();
        ((DragonOwnerCapability)player.getData(PLAYER_CAPABILITY)).setPlayerInstance(player);
        ModCapabilities.syncCapability(player);
    }

    public static void syncCapability(Player player) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new CompleteDataSync(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getEntity();
        ((DragonOwnerCapability)player.getData(PLAYER_CAPABILITY)).setPlayerInstance(player);
        ModCapabilities.syncCapability(player);
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        ((DragonOwnerCapability)player.getData(PLAYER_CAPABILITY)).setPlayerInstance(player);
        ModCapabilities.syncCapability(player);
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking startTracking) {
        Player trackingPlayer = startTracking.getEntity();
        if (trackingPlayer instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)trackingPlayer;
            Entity tracked = startTracking.getTarget();
            if (tracked instanceof ServerPlayer) {
                DragonOwnerCapability handler = (DragonOwnerCapability)tracked.getData(PLAYER_CAPABILITY);
                PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new CompleteDataSync(tracked.getId(), handler.serializeNBT((HolderLookup.Provider)tracked.level.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

