/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.blocks;

import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModBlockEntities;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.server.items.DragonEggItemBlock;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class DMREggBlock
extends DragonEggBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty HATCHING = BooleanProperty.create((String)"hatching");

    public DMREggBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HATCHING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HATCHING, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new DMREggBlockEntity(pPos, pState);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof DMREggBlockEntity) {
            CustomData customData;
            CompoundTag tag;
            DMREggBlockEntity e = (DMREggBlockEntity)blockEntity;
            String breedId = (String)pStack.get(ModComponents.DRAGON_BREED);
            Integer hatchTime = (Integer)pStack.getOrDefault(ModComponents.EGG_HATCH_TIME, (Object)ServerConfig.HATCH_TIME_CONFIG.intValue());
            String variantId = (String)pStack.get(ModComponents.DRAGON_VARIANT);
            if (ServerConfig.ENABLE_RANDOM_STATS) {
                Double healthAttribute = (Double)pStack.get(ModComponents.DRAGON_HEALTH_ATTRIBUTE);
                Double speedAttribute = (Double)pStack.get(ModComponents.DRAGON_MOVEMENT_SPEED_ATTRIBUTE);
                Double damageAttribute = (Double)pStack.get(ModComponents.DRAGON_ATTACK_ATTRIBUTE);
                if (healthAttribute != null) {
                    e.setHealthAttribute(healthAttribute);
                }
                if (speedAttribute != null) {
                    e.setSpeedAttribute(speedAttribute);
                }
                if (damageAttribute != null) {
                    e.setDamageAttribute(damageAttribute);
                }
            }
            e.setOwner(pPlacer.getUUID().toString());
            if (variantId != null) {
                e.setVariantId(variantId);
            }
            if (breedId != null) {
                e.setBreedId(breedId);
                e.setHatchTime(hatchTime);
            } else if (pStack.has(DataComponents.CUSTOM_DATA) && (tag = (customData = (CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("breed")) {
                e.setBreedId(tag.getString("breed"));
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level _level, BlockState _state, BlockEntityType<T> type) {
        return type != ModBlockEntities.DRAGON_EGG_BLOCK_ENTITY.get() ? null : (BlockEntityTicker)DMREggBlock.cast((level, pos, state, be) -> be.tick(level, pos, state));
    }

    private static <F extends BlockEntityTicker<DMREggBlockEntity>, T> T cast(F from) {
        return (T)from;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        String string;
        String string2;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DMREggBlockEntity) {
            DMREggBlockEntity e = (DMREggBlockEntity)blockEntity;
            string2 = e.getBreedId();
        } else {
            string2 = null;
        }
        String breedId = string2;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof DMREggBlockEntity) {
            DMREggBlockEntity e = (DMREggBlockEntity)blockEntity2;
            string = e.getVariantId();
        } else {
            string = null;
        }
        String variantId = string;
        IDragonBreed breed = DragonBreedsRegistry.getDragonBreed(breedId);
        IDragonBreed.Variant breedVariant = breed.getVariants().stream().filter(variant -> variant.id().equals(variantId)).findFirst().orElse(null);
        return DragonEggItemBlock.getDragonEggStack(breed, breedVariant);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderShape getRenderShape(BlockState pState) {
        return (Boolean)pState.getValue((Property)HATCHING) != false && ClientConfig.MOD_CONFIG_SPEC.isLoaded() && ClientConfig.RENDER_HATCHING_EGG ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!((Boolean)pState.getValue((Property)HATCHING)).booleanValue()) {
            if (!pLevel.isClientSide) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HATCHING, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void attack(BlockState state, Level level, BlockPos at, Player pPlayer) {
        DMREggBlockEntity e;
        BlockEntity blockEntity = level.getBlockEntity(at);
        if (blockEntity instanceof DMREggBlockEntity && Objects.equals((e = (DMREggBlockEntity)blockEntity).getBreedId(), "end") && !((Boolean)state.getValue((Property)HATCHING)).booleanValue()) {
            this.teleport(state, level, at);
        }
    }

    public BlockState updateShape(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, pDirection, pNeighborState, level, pCurrentPos, pNeighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return (BlockState)super.getStateForPlacement(p_196258_1_).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(p_196258_1_.getLevel().getFluidState(p_196258_1_.getClickedPos()).getType() == Fluids.WATER));
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (DMREggBlock.isFree((BlockState)pLevel.getBlockState(pPos.below())) && pPos.getY() >= pLevel.getMinBuildHeight()) {
            CompoundTag tag = null;
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof DMREggBlockEntity) {
                DMREggBlockEntity e = (DMREggBlockEntity)blockEntity;
                tag = e.saveWithoutMetadata((HolderLookup.Provider)pLevel.registryAccess());
            }
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (tag != null) {
                entity.blockData = tag;
            }
            this.falling(entity);
        }
    }

    public static DMREggBlockEntity place(ServerLevel level, BlockPos pos, BlockState state, IDragonBreed breed, IDragonBreed.Variant variant) {
        level.setBlock(pos, state, 3);
        DMREggBlockEntity data = (DMREggBlockEntity)level.getBlockEntity(pos);
        if (breed == null) {
            throw new IllegalArgumentException("Breed cannot be null");
        }
        data.setBreed(breed);
        data.setVariantId(variant != null ? variant.id() : null);
        data.setHatchTime(breed.getHatchTime());
        return data;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource random) {
        BlockEntity blockEntity;
        if (((Boolean)pState.getValue((Property)HATCHING)).booleanValue() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof DMREggBlockEntity) {
            DMREggBlockEntity e = (DMREggBlockEntity)blockEntity;
            for (int i = 0; i < random.nextIntBetweenInclusive(4, 7); ++i) {
                this.addHatchingParticles(e.getBreed(), pLevel, pPos, random);
            }
        }
    }

    public void addHatchingParticles(IDragonBreed breed, Level level, BlockPos pos, RandomSource random) {
        double px = (double)pos.getX() + random.nextDouble();
        double py = (double)pos.getY() + random.nextDouble();
        double pz = (double)pos.getZ() + random.nextDouble();
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        ParticleOptions particle = DMREggBlock.getHatchingParticles(breed, random);
        DMREggBlock.spawnHatchingParticle(level, pos, random, px, py, pz, ox, oy, oz, particle);
    }

    public static ParticleOptions getHatchingParticles(IDragonBreed breed, RandomSource random) {
        if (breed.getHatchParticles() != null) {
            return breed.getHatchParticles();
        }
        return DMREggBlock.dustParticleFor(breed, random);
    }

    public static DustParticleOptions dustParticleFor(IDragonBreed breed, RandomSource random) {
        Vec3 vec = Vec3.fromRGB24((int)(random.nextDouble() < 0.75 ? breed.getPrimaryColor() : breed.getSecondaryColor()));
        return new DustParticleOptions(new Vector3f((float)vec.x, (float)vec.y, (float)vec.z), 1.0f);
    }

    static void spawnHatchingParticle(Level level, BlockPos pos, RandomSource random, double px, double py, double pz, double ox, double oy, double oz, ParticleOptions particle) {
        if (particle.getType() == ParticleTypes.DUST) {
            py = (double)pos.getY() + (random.nextDouble() - 0.5) + 1.0;
        } else if (particle.getType() == ParticleTypes.PORTAL) {
            ox = (random.nextDouble() - 0.5) * 2.0;
            oy = (random.nextDouble() - 0.5) * 2.0;
            oz = (random.nextDouble() - 0.5) * 2.0;
        }
        level.addParticle(particle, px, py, pz, ox, oy, oz);
    }
}

