/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.server.entity.dragon.CoreDragonComponent;
import lombok.Generated;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

abstract class DragonAnimationComponent
extends CoreDragonComponent {
    public static final RawAnimation NECK_TURN = RawAnimation.begin().thenLoop("neck_turn");
    public static final RawAnimation NECK_TURN_FLIGHT = RawAnimation.begin().thenLoop("neck_turn_flight");
    public static final RawAnimation GLIDE = RawAnimation.begin().thenLoop("glide");
    public static final RawAnimation FLY = RawAnimation.begin().thenLoop("fly");
    public static final RawAnimation FLY_CLIMB = RawAnimation.begin().thenLoop("fly_climb");
    public static final RawAnimation DIVE = RawAnimation.begin().thenLoop("dive");
    public static final RawAnimation HOVER = RawAnimation.begin().thenLoop("hover");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    public static final RawAnimation SPRINT = RawAnimation.begin().thenLoop("run");
    public static final RawAnimation SNEAK_IDLE = RawAnimation.begin().thenLoop("sneak_idle");
    public static final RawAnimation SNEAK_WALK = RawAnimation.begin().thenLoop("sneak_walk");
    public static final RawAnimation SWIM = RawAnimation.begin().thenLoop("swim");
    public static final RawAnimation SWIM_IDLE = RawAnimation.begin().thenLoop("swim_idle");
    public static final RawAnimation SIT = RawAnimation.begin().thenLoop("sit");
    public static final RawAnimation SIT_ALT = RawAnimation.begin().thenLoop("sit-alt");
    public static final RawAnimation BITE = RawAnimation.begin().thenPlay("bite");
    public static final RawAnimation BREATH = RawAnimation.begin().thenPlay("breath");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected AnimationController<?> animationController;
    protected AnimationController<?> headController;
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected DragonAnimationComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.addDragonAnimations(controllers);
    }

    private void addDragonAnimations(AnimatableManager.ControllerRegistrar data) {
        this.headController = new AnimationController((GeoAnimatable)this, "head-controller", 0, state -> state.setAndContinue(this.isFlying() ? NECK_TURN_FLIGHT : NECK_TURN));
        this.headController.triggerableAnim("bite", BITE);
        this.headController.triggerableAnim("breath", BREATH);
        data.add(this.headController);
        this.animationController = new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            Vec3 motio = new Vec3(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo);
            boolean isMovingHorizontal = Math.sqrt(Math.pow(motio.x, 2.0) + Math.pow(motio.z, 2.0)) > 0.01;
            state.setControllerSpeed(1.0f);
            if (this.isSwimming()) {
                return state.setAndContinue(SWIM);
            }
            if (this.isInWater()) {
                if (isMovingHorizontal) {
                    return state.setAndContinue(SWIM);
                }
                if (this.level.getBlockState(this.blockPosition().below()).isSolidRender((BlockGetter)this.level, this.blockPosition().below())) {
                    return state.setAndContinue(IDLE);
                }
                return state.setAndContinue(SWIM_IDLE);
            }
            if (this.isFlying() || this.isPathFinding() && !this.onGround() && !this.isInWater()) {
                if (isMovingHorizontal) {
                    if (this.isSprinting()) {
                        Vec3 delta = this.getDeltaMovement().multiply(0.0, 0.25, 0.0);
                        if (delta.y < -0.25) {
                            return state.setAndContinue(DIVE);
                        }
                        if (delta.y > 0.25) {
                            return state.setAndContinue(FLY_CLIMB);
                        }
                        if (delta.y > 0.0) {
                            return state.setAndContinue(FLY);
                        }
                        return state.setAndContinue(GLIDE);
                    }
                    return state.setAndContinue(FLY);
                }
                return state.setAndContinue(HOVER);
            }
            if (this.swinging && this.getTarget() != null) {
                return state.setAndContinue(BITE);
            }
            if (this.getDragon().isRandomlySitting()) {
                return state.setAndContinue(SIT);
            }
            if (this.isOrderedToSit()) {
                TargetingConditions lookAtContext = TargetingConditions.forNonCombat().range(10.0).selector(p_25531_ -> EntitySelector.notRiding((Entity)this).test(p_25531_));
                Player lookAt = this.level().getNearestPlayer(lookAtContext, (LivingEntity)this, this.getX(), this.getEyeY(), this.getZ());
                if (lookAt != null) {
                    return state.setAndContinue(SIT_ALT);
                }
                return state.setAndContinue(SIT);
            }
            if (isMovingHorizontal) {
                if (this.isSprinting()) {
                    return state.setAndContinue(SPRINT);
                }
                state.setControllerSpeed(1.1f + (this.isShiftKeyDown() ? 2.0f : this.getSpeed()));
                return state.setAndContinue(this.isShiftKeyDown() ? SNEAK_WALK : WALK);
            }
            return state.setAndContinue(this.isShiftKeyDown() ? SNEAK_IDLE : IDLE);
        });
        this.animationController.setSoundKeyframeHandler(sound -> {
            if (sound.getKeyframeData().getSound().equalsIgnoreCase("flap")) {
                this.onFlap();
            }
        });
        data.add(this.animationController);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Generated
    public AnimationController<?> getAnimationController() {
        return this.animationController;
    }

    @Generated
    public AnimationController<?> getHeadController() {
        return this.headController;
    }
}

