/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.server.entity.dragon.DragonBreathComponent;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;

abstract class DragonBreedComponent
extends DragonBreathComponent {
    protected static final EntityDataAccessor<String> breedDataAccessor = SynchedEntityData.defineId(DragonBreedComponent.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<String> origBreedDataAccessor = SynchedEntityData.defineId(DragonBreedComponent.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<String> variantDataAccessor = SynchedEntityData.defineId(DragonBreedComponent.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<Boolean> wasHatchedDataAccessor = SynchedEntityData.defineId(DragonBreedComponent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean breedIsSet = false;
    protected IDragonBreed breed;

    protected DragonBreedComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(breedDataAccessor, (Object)"");
        builder.define(origBreedDataAccessor, (Object)"");
        builder.define(variantDataAccessor, (Object)"");
        builder.define(wasHatchedDataAccessor, (Object)false);
    }

    public abstract void updateAgeProperties();

    public boolean wasHatched() {
        return (Boolean)this.entityData.get(wasHatchedDataAccessor);
    }

    public void setHatched(boolean wasHatched) {
        this.entityData.set(wasHatchedDataAccessor, (Object)wasHatched);
    }

    public IDragonBreed getBreed() {
        String origBreed = (String)this.getEntityData().get(origBreedDataAccessor);
        if (!origBreed.isBlank() && DragonBreedsRegistry.hasDragonBreed(origBreed)) {
            return DragonBreedsRegistry.getDragonBreed(origBreed);
        }
        return DragonBreedsRegistry.getDragonBreed(this.getBreedId());
    }

    public void setBreed(IDragonBreed dragonBreed) {
        if (this.breed != dragonBreed || !this.breedIsSet) {
            if (dragonBreed == null || dragonBreed.getId() == null || dragonBreed.getId().isBlank()) {
                return;
            }
            if (dragonBreed == DragonBreedsRegistry.getDefault() && this.breed != dragonBreed) {
                return;
            }
            this.breedIsSet = true;
            if (this.breed != null) {
                this.breed.close(this.getDragon());
            }
            this.breed = dragonBreed;
            dragonBreed.initialize(this.getDragon());
            this.getEntityData().set(breedDataAccessor, (Object)dragonBreed.getId());
            if (((String)this.getEntityData().get(origBreedDataAccessor)).isBlank()) {
                this.getEntityData().set(origBreedDataAccessor, (Object)dragonBreed.getId());
            }
        }
    }

    public String getBreedId() {
        return (String)this.getEntityData().get(breedDataAccessor);
    }

    public IDragonBreed.Variant getVariant() {
        String id = this.getVariantId();
        return this.getBreed().getVariants().stream().filter(v -> v.id().equals(id)).findFirst().orElse(null);
    }

    public void setVariant(String variant) {
        this.getEntityData().set(variantDataAccessor, (Object)(variant != null ? variant : ""));
    }

    public String getVariantId() {
        return (String)this.getEntityData().get(variantDataAccessor);
    }

    public boolean hasVariant() {
        return !this.getVariantId().isBlank() && this.getBreed().getVariants().stream().anyMatch(v -> v.id().equals(this.getVariantId()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 20 == 0) {
            this.getBreed().tick(this.getDragon());
        }
    }

    public void baseTick() {
        super.baseTick();
        if (!this.breedIsSet && this.getBreed() != null) {
            if (this.getBreed() != null) {
                this.getBreed().close(this.getDragon());
            }
            this.setBreed(this.getBreed());
            if (this.getBreed() != null) {
                this.getBreed().initialize(this.getDragon());
                this.breedIsSet = true;
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getBreed() != null && this.getBreed().getId() != null) {
            compound.putString("breed", this.getBreed().getId());
        }
        if (this.getEntityData().get(origBreedDataAccessor) != null) {
            compound.putString("orig_breed", (String)this.getEntityData().get(origBreedDataAccessor));
        }
        if (this.getEntityData().get(variantDataAccessor) != null) {
            compound.putString("variant", (String)this.getEntityData().get(variantDataAccessor));
        }
        compound.putBoolean("breedIsSet", this.breedIsSet);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("orig_breed")) {
            this.getEntityData().set(origBreedDataAccessor, (Object)compound.getString("orig_breed"));
        }
        if (compound.contains("breed")) {
            String breedKey = compound.getString("breed");
            IDragonBreed breed = DragonBreedsRegistry.getDragonBreed(breedKey);
            this.setBreed(breed);
        }
        if (compound.contains("variant")) {
            this.getEntityData().set(variantDataAccessor, (Object)compound.getString("variant"));
        }
        if (compound.contains("breedIsSet")) {
            this.breedIsSet = compound.getBoolean("breedIsSet");
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (breedDataAccessor.equals(data)) {
            String breedId = (String)this.getEntityData().get(breedDataAccessor);
            IDragonBreed dragonBreed = DragonBreedsRegistry.getDragonBreed(breedId);
            this.setBreed(dragonBreed);
            this.updateAgeProperties();
        }
    }
}

