/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.items.dev;

import dmr.DragonMounts.server.items.DMRDevItem;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.BreedingUtils;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HabitatOutcomeCheck
extends DMRDevItem {
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pIsSelected && pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            if (!pLevel.isClientSide && pPlayer.tickCount % 10 == 0) {
                List<Map.Entry<Integer, IDragonBreed>> outcomes = BreedingUtils.getHabitatBreedOutcomes((ServerLevel)pLevel, pPlayer.blockPosition());
                if (!outcomes.isEmpty()) {
                    StringJoiner joiner = new StringJoiner(", ");
                    outcomes.stream().limit(3L).forEach(outcome -> joiner.add(((IDragonBreed)outcome.getValue()).getId() + ": " + String.valueOf(outcome.getKey())));
                    pPlayer.displayClientMessage((Component)Component.literal((String)joiner.toString()), true);
                } else {
                    pPlayer.displayClientMessage((Component)Component.literal((String)"None"), true);
                }
            }
        }
    }
}

