/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.util.type_adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dmr.DragonMounts.DMR;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListAdapter
implements JsonDeserializer<List<Item>>,
JsonSerializer<List<Item>> {
    public List<Item> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonArray array = json.getAsJsonArray();
            ArrayList<Item> list = new ArrayList<Item>();
            if (array.isEmpty()) {
                return List.of();
            }
            for (JsonElement element : array) {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)element.getAsString()));
                list.add(item);
            }
            return list;
        }
        catch (Exception e) {
            DMR.LOGGER.warn("Failed to deserialize Item list: {}", (Object)json);
            return List.of();
        }
    }

    public JsonElement serialize(List<Item> src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isEmpty()) {
            return DMR.getGson().toJsonTree(List.of());
        }
        try {
            JsonArray array = new JsonArray();
            for (Item item : src) {
                array.add((JsonElement)new JsonPrimitive(BuiltInRegistries.ITEM.getKey((Object)item).toString()));
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return DMR.getGson().toJsonTree(List.of());
        }
    }
}

