/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.curios.backpack;

import com.craftyeddie.thenorthwildhunt.menu.BackpackMenu;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BackpackItem
extends Item
implements ICurioItem,
GeoItem {
    private static final String NBT_KEY = "BackpackInventory";
    private final int rows;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BackpackItem(Item.Properties properties, int rows) {
        super(properties.stacksTo(1));
        this.rows = rows;
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int getRows() {
        return this.rows;
    }

    public int getSlotCount() {
        return this.rows * 9;
    }

    public ItemStackHandler getInventory(ItemStack stack, Level level) {
        CompoundTag tag;
        ItemStackHandler handler = new ItemStackHandler(this.getSlotCount());
        if (stack.has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains(NBT_KEY)) {
            handler.deserializeNBT((HolderLookup.Provider)level.registryAccess(), tag.getCompound(NBT_KEY));
        }
        return handler;
    }

    public void saveInventory(ItemStack stack, ItemStackHandler handler, Level level) {
        CompoundTag tag = new CompoundTag();
        tag.put(NBT_KEY, (Tag)handler.serializeNBT((HolderLookup.Provider)level.registryAccess()));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void saveHandlerToStack(ItemStack stack, ItemStackHandler handler, Level level) {
        CompoundTag tag = new CompoundTag();
        tag.put(NBT_KEY, (Tag)handler.serializeNBT((HolderLookup.Provider)level.registryAccess()));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public InteractionResultHolder<ItemStack> use(final Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            MenuProvider provider = new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int containerId, Inventory inv, Player p) {
                    ItemStackHandler handler = BackpackItem.this.getInventory(stack, level);
                    return new BackpackMenu(containerId, inv, handler, stack, level, BackpackItem.this.rows);
                }
            };
            player.openMenu(provider, buf -> buf.writeVarInt(this.rows));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

