/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.curios.backpack;

import com.craftyeddie.thenorthwildhunt.curios.backpack.BackpackItem;
import com.craftyeddie.thenorthwildhunt.curios.backpack.BackpackModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class BackpackRenderer
extends GeoItemRenderer<BackpackItem>
implements ICurioRenderer {
    public BackpackRenderer() {
        super((GeoModel)new BackpackModel());
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!"back".equals(slotContext.identifier())) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(-0.6f, -1.1f, -0.6f);
        poseStack.scale(1.25f, 1.25f, 1.25f);
        this.renderByItem(stack, ItemDisplayContext.NONE, poseStack, buffer, light, 0);
        poseStack.popPose();
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        switch (transformType) {
            case GUI: {
                poseStack.scale(1.0f, 1.0f, 1.0f);
                poseStack.translate(0.0f, 0.0f, 0.0f);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                poseStack.translate(0.5f, 0.5f, 0.5f);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                poseStack.scale(0.9f, 0.9f, 0.9f);
                poseStack.translate(0.0f, 0.5f, 0.0f);
                break;
            }
        }
        super.renderByItem(stack, transformType, poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

