/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.entity.custom;

import com.craftyeddie.thenorthwildhunt.entity.ModEntities;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BearEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean isRoaring = false;
    private int roarTicks = 0;
    private final HashMap<UUID, Long> roarMemory = new HashMap();
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bear.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.bear.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.bear.run");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.bear.attack");
    private static final RawAnimation ROAR = RawAnimation.begin().thenPlay("animation.bear.roar");

    public BearEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 4.0);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"entities/bear"));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BearRoarGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BearAttackGoal(this, 2.0, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, e -> e.getType() != ModEntities.BEAR.get() && !e.getType().toString().contains("squid") && !e.getType().toString().contains("cod") && !e.getType().toString().contains("salmon") && !e.getType().toString().contains("pufferfish") && !e.getType().toString().contains("tropical_fish")));
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.POLAR_BEAR_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.POLAR_BEAR_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.POLAR_BEAR_DEATH;
    }

    protected float getSoundVolume() {
        return 1.3f;
    }

    public float getVoicePitch() {
        return 0.8f;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob partner) {
        return (AgeableMob)((EntityType)ModEntities.BEAR.get()).create((Level)serverLevel);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "controller", 2, this::animationPredicate);
        main.triggerableAnim("attack", ATTACK);
        main.triggerableAnim("roar", ROAR);
        controllers.add(main);
    }

    private PlayState animationPredicate(AnimationState<BearEntity> state) {
        boolean isMoving;
        if (this.isRoaring) {
            state.setAndContinue(ROAR);
            return PlayState.CONTINUE;
        }
        double horizontalSpeed = this.getDeltaMovement().horizontalDistanceSqr();
        boolean bl = isMoving = horizontalSpeed > 0.01 || this.getNavigation().isInProgress();
        if (isMoving) {
            if (horizontalSpeed > 0.04) {
                state.setAndContinue(RUN);
            } else {
                state.setAndContinue(WALK);
            }
        } else {
            state.setAndContinue(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public boolean doHurtTarget(Entity target) {
        boolean flag = super.doHurtTarget(target);
        if (flag && target instanceof LivingEntity) {
            this.triggerAnim("controller", "attack");
        }
        return flag;
    }

    public void tick() {
        super.tick();
        if (this.isRoaring) {
            ++this.roarTicks;
            if (this.getNavigation().isInProgress()) {
                this.getNavigation().stop();
            }
            if (this.roarTicks > 40) {
                this.isRoaring = false;
                this.roarTicks = 0;
                LivingEntity target = this.getTarget();
                if (target != null) {
                    this.getNavigation().moveTo((Entity)target, 2.0);
                }
            }
        }
    }

    protected boolean shouldDropLoot() {
        return true;
    }

    static class BearRoarGoal
    extends Goal {
        private final BearEntity bear;

        public BearRoarGoal(BearEntity bear) {
            this.bear = bear;
        }

        public boolean canUse() {
            LivingEntity target = this.bear.getTarget();
            if (target == null || this.bear.isRoaring) {
                return false;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                UUID id = player.getUUID();
                long now = this.bear.level().getGameTime();
                Long lastRoar = this.bear.roarMemory.get(id);
                return lastRoar == null || now - lastRoar > 6000L;
            }
            return false;
        }

        public void start() {
            LivingEntity target = this.bear.getTarget();
            if (target instanceof Player) {
                Player player = (Player)target;
                this.bear.isRoaring = true;
                this.bear.roarTicks = 0;
                this.bear.roarMemory.put(player.getUUID(), this.bear.level().getGameTime());
                this.bear.getNavigation().stop();
                this.bear.triggerAnim("controller", "roar");
                this.bear.playSound(SoundEvents.POLAR_BEAR_WARNING, 2.0f, 0.8f);
            }
        }

        public boolean canContinueToUse() {
            return this.bear.isRoaring;
        }
    }

    static class BearAttackGoal
    extends MeleeAttackGoal {
        private final BearEntity bear;

        public BearAttackGoal(BearEntity bear, double speed, boolean useLongMemory) {
            super((PathfinderMob)bear, speed, useLongMemory);
            this.bear = bear;
        }

        public boolean canUse() {
            if (this.bear.isRoaring) {
                return false;
            }
            LivingEntity target = this.mob.getTarget();
            if (target == null || !target.isAlive()) {
                return false;
            }
            return this.mob.getNavigation().createPath((Entity)target, 0) != null && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.bear.isRoaring && super.canContinueToUse();
        }
    }
}

