/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.entity.custom;

import com.craftyeddie.thenorthwildhunt.entity.ModEntities;
import com.craftyeddie.thenorthwildhunt.sound.ModSounds;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TimberWolfEntity
extends Wolf
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long nextHowlTime = 0L;
    private boolean hasAggroed = false;
    private boolean isHowling = false;
    private long howlEndTime = 0L;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.timberwolf.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.timberwolf.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.timberwolf.run");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.timberwolf.attack");
    private static final RawAnimation HOWL = RawAnimation.begin().thenPlay("animation.timberwolf.howl");

    public TimberWolfEntity(EntityType<? extends Wolf> type, Level level) {
        super(type, level);
    }

    public boolean isHowling() {
        return this.isHowling;
    }

    public void setHowling(boolean howling) {
        this.isHowling = howling;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Wolf.createAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"entities/timber_wolf"));
    }

    protected void registerGoals() {
        this.goalSelector.removeAllGoals(g -> true);
        this.targetSelector.removeAllGoals(g -> true);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TimberWolfAttackGoal(this, 1.6, true));
        this.goalSelector.addGoal(2, (Goal)new TimberWolfPanicGoal(this, 1.6));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, e -> e.getType() != ModEntities.TIMBER_WOLF.get() && !e.getType().toString().contains("squid") && !e.getType().toString().contains("cod") && !e.getType().toString().contains("salmon") && !e.getType().toString().contains("pufferfish") && !e.getType().toString().contains("tropical_fish")));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean isTame() {
        return false;
    }

    public boolean isAngryAt(LivingEntity target) {
        return target instanceof Player || super.isAngryAt(target);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof Player) {
            return true;
        }
        return super.wantsToAttack(target, owner);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WOLF_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    public void playAmbientSound() {
        SoundEvent sound = this.getAmbientSound();
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    protected void playHurtSound(DamageSource source) {
        SoundEvent sound = this.getHurtSound(source);
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    protected void playDeathSound() {
        SoundEvent sound = this.getDeathSound();
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public float getVoicePitch() {
        return 0.5f + this.random.nextFloat() * 0.2f;
    }

    protected float getSoundVolume() {
        return 1.2f;
    }

    public Wolf getBreedOffspring(ServerLevel serverLevel, AgeableMob partner) {
        return (Wolf)((EntityType)ModEntities.TIMBER_WOLF.get()).create((Level)serverLevel);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            long gameTime = this.level().getGameTime();
            if (this.level().isNight() && gameTime > this.nextHowlTime && this.getRandom().nextInt(200) == 0) {
                this.setHowling(true);
                this.playSound((SoundEvent)ModSounds.TIMBER_WOLF_HOWL.get(), 1.0f, 1.0f);
                this.triggerAnim("controller", "howl");
                this.nextHowlTime = gameTime + 2400L;
                this.howlEndTime = gameTime + 80L;
            }
            if (this.isHowling && gameTime >= this.howlEndTime) {
                this.setHowling(false);
            }
            if (!this.hasAggroed && this.getTarget() != null) {
                this.playSound((SoundEvent)ModSounds.TIMBER_WOLF_GROWL.get(), 1.0f, 1.0f);
                this.hasAggroed = true;
            } else if (this.getTarget() == null) {
                this.hasAggroed = false;
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "controller", 2, this::animationPredicate);
        main.triggerableAnim("attack", ATTACK);
        main.triggerableAnim("howl", HOWL);
        controllers.add(main);
    }

    private PlayState animationPredicate(AnimationState<TimberWolfEntity> state) {
        double horizontalSpeed;
        boolean isMoving;
        AnimationController controller = state.getController();
        if (controller.getCurrentAnimation() != null && "animation.timberwolf.howl".equals(controller.getCurrentAnimation().animation().name()) && !controller.hasAnimationFinished()) {
            this.setHowling(true);
            return PlayState.CONTINUE;
        }
        if (this.isHowling()) {
            this.setHowling(false);
        }
        boolean bl = isMoving = (horizontalSpeed = this.getDeltaMovement().horizontalDistanceSqr()) > 0.01 || this.getNavigation().isInProgress();
        if (isMoving) {
            if (horizontalSpeed > 0.04) {
                state.setAndContinue(RUN);
            } else {
                state.setAndContinue(WALK);
            }
        } else {
            state.setAndContinue(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public boolean doHurtTarget(Entity target) {
        if (this.isHowling) {
            return false;
        }
        boolean flag = super.doHurtTarget(target);
        if (flag && target instanceof LivingEntity) {
            this.triggerAnim("controller", "attack");
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.TIMBER_WOLF_BITE.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
        return flag;
    }

    protected boolean shouldDropLoot() {
        return true;
    }

    static class TimberWolfAttackGoal
    extends MeleeAttackGoal {
        private final TimberWolfEntity wolf;

        public TimberWolfAttackGoal(TimberWolfEntity wolf, double speedModifier, boolean useLongMemory) {
            super((PathfinderMob)wolf, speedModifier, useLongMemory);
            this.wolf = wolf;
        }

        public boolean canUse() {
            if (this.wolf.isHowling()) {
                return false;
            }
            LivingEntity target = this.mob.getTarget();
            if (target == null || !target.isAlive()) {
                return false;
            }
            if (this.mob.getNavigation().createPath((Entity)target, 0) == null) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.wolf.isHowling() && super.canContinueToUse();
        }

        public void start() {
            super.start();
            this.wolf.setAggressive(true);
        }

        public void stop() {
            super.stop();
            this.wolf.setAggressive(false);
        }
    }

    static class TimberWolfPanicGoal
    extends PanicGoal {
        private final TimberWolfEntity wolf;

        public TimberWolfPanicGoal(TimberWolfEntity wolf, double speedModifier) {
            super((PathfinderMob)wolf, speedModifier);
            this.wolf = wolf;
        }

        public boolean canUse() {
            return !this.wolf.isHowling() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.wolf.isHowling() && super.canContinueToUse();
        }
    }
}

