/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.entity.custom;

import com.craftyeddie.thenorthwildhunt.ModItems;
import com.craftyeddie.thenorthwildhunt.entity.ModEntities;
import com.craftyeddie.thenorthwildhunt.item.WolfFangDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WolfFangSpearEntity
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec2 groundedOffset;
    private float spinRotation;
    private ItemStack spearStack;
    private int loyaltyLevel;
    private int pierceRemaining;
    private boolean returning;

    public WolfFangSpearEntity(EntityType<? extends WolfFangSpearEntity> type, Level level) {
        super(type, level);
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        this.setBaseDamage(6.0);
        this.spearStack = new ItemStack((ItemLike)ModItems.WOLF_FANG_SPEAR.get());
    }

    public WolfFangSpearEntity(Level level, Player player, ItemStack thrown) {
        super((EntityType)ModEntities.WOLF_FANG_SPEAR.get(), (LivingEntity)player, level, thrown.copy(), thrown.copy());
        this.spearStack = thrown.copy();
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        this.setBaseDamage(6.0);
        HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        this.loyaltyLevel = lookup.get(Enchantments.LOYALTY).map(h -> EnchantmentHelper.getTagEnchantmentLevel((Holder)h, (ItemStack)this.spearStack)).orElse(0);
        this.pierceRemaining = lookup.get(Enchantments.PIERCING).map(h -> EnchantmentHelper.getTagEnchantmentLevel((Holder)h, (ItemStack)this.spearStack)).orElse(0);
    }

    public void shootFromPlayer(Player player, float velocity, float inaccuracy) {
        float pitch = player.getXRot();
        float yaw = player.getYRot();
        double dx = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
        double dy = -Math.sin(Math.toRadians(pitch));
        double dz = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
        this.shoot(dx, dy * 0.9, dz, velocity, inaccuracy);
        this.updateRotationFromMotion();
    }

    private void updateRotationFromMotion() {
        Vec3 v = this.getDeltaMovement();
        double dx = v.x;
        double dy = v.y;
        double dz = v.z;
        if (dx * dx + dz * dz > 1.0E-4) {
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float targetPitch = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            this.setYRot(this.smoothLerpRotation(this.getYRot(), targetYaw));
            this.setXRot(this.smoothLerpRotation(this.getXRot(), targetPitch));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    private float smoothLerpRotation(float prev, float next) {
        float delta;
        for (delta = next - prev; delta < -180.0f; delta += 360.0f) {
        }
        while (delta >= 180.0f) {
            delta -= 360.0f;
        }
        while (delta < -90.0f) {
            delta += 180.0f;
        }
        while (delta >= 90.0f) {
            delta -= 180.0f;
        }
        while (delta < -45.0f) {
            delta += 90.0f;
        }
        while (delta >= 45.0f) {
            delta -= 90.0f;
        }
        while (delta < -22.5f) {
            delta += 45.0f;
        }
        while (delta >= 22.5f) {
            delta -= 45.0f;
        }
        return prev + delta * 0.25f;
    }

    public void tick() {
        super.tick();
        if (!this.inGround && !this.returning) {
            this.spinRotation += 12.0f;
            if (this.spinRotation >= 360.0f) {
                this.spinRotation -= 360.0f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.96, 1.0));
            this.updateRotationFromMotion();
        }
        if (this.loyaltyLevel > 0 && (this.inGround || this.returning)) {
            Entity owner = this.getOwner();
            if (owner != null && owner.isAlive()) {
                this.noPhysics = true;
                this.returning = true;
                Vec3 toOwner = owner.getEyePosition().subtract(this.position());
                double dist = toOwner.length();
                double accel = 0.04 + 0.02 * (double)this.loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(toOwner.normalize().scale(accel)));
                this.updateRotationFromMotion();
                if (dist < 1.5 && !this.level().isClientSide) {
                    if (owner instanceof Player) {
                        ItemStack give;
                        Player p = (Player)owner;
                        ItemStack itemStack = give = this.spearStack == null || this.spearStack.isEmpty() ? new ItemStack((ItemLike)ModItems.WOLF_FANG_SPEAR.get()) : this.spearStack.copy();
                        if (!p.getInventory().add(give)) {
                            this.spawnAtLocation(give);
                        }
                    } else {
                        this.spawnAtLocation(this.getDefaultPickupItem());
                    }
                    this.discard();
                }
            } else if (!this.level().isClientSide) {
                this.spawnAtLocation(this.getDefaultPickupItem());
                this.discard();
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.level().isClientSide) {
            return;
        }
        Entity target = result.getEntity();
        float damage = (float)this.getBaseDamage();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)(this.spearStack == null ? ItemStack.EMPTY : this.spearStack), (Entity)target, (DamageSource)this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
        }
        Entity owner = this.getOwner();
        target.hurt(this.damageSources().thrown((Entity)this, owner), damage);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            this.doPostHurtEffects(living);
            if (!living.isAlive() && owner instanceof Player) {
                EntityType type;
                Player p = (Player)owner;
                if (this.spearStack != null && ((type = living.getType()) == EntityType.WOLF || type == ModEntities.TIMBER_WOLF.get())) {
                    int kills = (Integer)this.spearStack.getOrDefault(WolfFangDataComponents.WOLF_KILLS, (Object)0);
                    this.spearStack.set(WolfFangDataComponents.WOLF_KILLS, (Object)(++kills));
                    if (kills >= 25) {
                        ResourceKey wolfSlayerKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"wolf_slayer"));
                        p.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(wolfSlayerKey).ifPresent(holder -> {
                            EnchantmentHelper.updateEnchantments((ItemStack)this.spearStack, ench -> ench.set((Holder)holder, 1));
                            this.spearStack.set(WolfFangDataComponents.WOLF_KILLS, (Object)0);
                            p.displayClientMessage((Component)Component.literal((String)"Your spear gained Wolf Slayer!"), true);
                        });
                    }
                }
            }
        }
        if (owner instanceof Player) {
            Player p = (Player)owner;
            if (!p.getAbilities().instabuild && this.spearStack != null) {
                this.spearStack.hurtAndBreak(1, (LivingEntity)p, EquipmentSlot.MAINHAND);
            }
        }
        if (this.pierceRemaining > 0) {
            --this.pierceRemaining;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            this.updateRotationFromMotion();
            return;
        }
        if (this.loyaltyLevel > 0) {
            this.setNoPhysics(true);
            this.returning = true;
            this.inGround = false;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 0.5f);
        } else {
            this.spawnAtLocation(this.getDefaultPickupItem());
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        if (!this.level().isClientSide) {
            Entity owner = this.getOwner();
            if (owner instanceof Player) {
                Player p = (Player)owner;
                if (!p.getAbilities().instabuild && this.spearStack != null) {
                    this.spearStack.hurtAndBreak(1, (LivingEntity)p, EquipmentSlot.MAINHAND);
                }
            }
            if (this.loyaltyLevel > 0) {
                this.noPhysics = true;
                this.returning = true;
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 0.5f);
            } else {
                this.pickup = AbstractArrow.Pickup.ALLOWED;
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        if (this.spearStack == null || this.spearStack.isEmpty()) {
            return new ItemStack((ItemLike)ModItems.WOLF_FANG_SPEAR.get());
        }
        return this.spearStack.copy();
    }

    public boolean isGrounded() {
        return this.inGround;
    }

    public float getSpinRotation() {
        return this.spinRotation;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

