/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.menu;

import com.craftyeddie.thenorthwildhunt.curios.backpack.BackpackItem;
import com.craftyeddie.thenorthwildhunt.menu.ModMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class BackpackMenu
extends AbstractContainerMenu {
    private final ItemStackHandler handler;
    private final ItemStack linkedStack;
    private final Level level;
    private final int rows;
    private final int size;
    private int scrollOffset = 0;

    public BackpackMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, buf.readVarInt());
    }

    private BackpackMenu(int containerId, Inventory playerInventory, int rows) {
        this(containerId, playerInventory, new ItemStackHandler(rows * 9), ItemStack.EMPTY, playerInventory.player.level(), rows);
    }

    public BackpackMenu(int containerId, Inventory playerInventory, ItemStackHandler handler, ItemStack linkedStack, Level level, int rows) {
        super(ModMenus.BACKPACK.get(), containerId);
        int col;
        this.handler = handler;
        this.linkedStack = linkedStack;
        this.level = level;
        this.rows = rows;
        this.size = rows * 9;
        boolean scrollable = rows > 6;
        int visibleRows = scrollable ? 6 : rows;
        for (int row = 0; row < visibleRows; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = col + row * 9;
                if (scrollable) {
                    this.addSlot((Slot)new ScrollableSlot(handler, index, 8 + col * 18, 18 + row * 18));
                    continue;
                }
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)handler, index, 8 + col * 18, 18 + row * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return !(stack.getItem() instanceof BackpackItem);
                    }
                });
            }
        }
        int invY = !scrollable && rows == 3 ? 84 : 18 + visibleRows * 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot((Container)playerInventory, col2 + row * 9 + 9, 8 + col2 * 18, invY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, invY + 58));
        }
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = offset;
        for (int i = 0; i < 54 && i < this.slots.size(); ++i) {
            Object object = this.slots.get(i);
            if (!(object instanceof ScrollableSlot)) continue;
            ScrollableSlot s = (ScrollableSlot)((Object)object);
            s.setIndex(i + this.scrollOffset * 9);
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack empty = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            ItemStack copy = stackInSlot.copy();
            if (index < 54 ? !this.moveItemStackTo(stackInSlot, 54, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, 54, false)) {
                return empty;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            return copy;
        }
        return empty;
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide && this.linkedStack != null && !this.linkedStack.isEmpty()) {
            BackpackItem.saveHandlerToStack(this.linkedStack, this.handler, this.level);
        }
    }

    public int getRows() {
        return this.rows;
    }

    private static class ScrollableSlot
    extends SlotItemHandler {
        private int logicalIndex;

        public ScrollableSlot(ItemStackHandler handler, int index, int x, int y) {
            super((IItemHandler)handler, index, x, y);
            this.logicalIndex = index;
        }

        public void setIndex(int newIndex) {
            this.logicalIndex = newIndex;
        }

        public ItemStack getItem() {
            return this.getItemHandler().getStackInSlot(this.logicalIndex);
        }

        public void set(ItemStack stack) {
            IItemHandler iItemHandler = this.getItemHandler();
            if (iItemHandler instanceof ItemStackHandler) {
                ItemStackHandler ish = (ItemStackHandler)iItemHandler;
                ish.setStackInSlot(this.logicalIndex, stack);
                this.setChanged();
            }
        }

        public boolean mayPlace(ItemStack stack) {
            return !(stack.getItem() instanceof BackpackItem);
        }
    }
}

