/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.menu.screen;

import com.craftyeddie.thenorthwildhunt.menu.BackpackMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BackpackScreen
extends AbstractContainerScreen<BackpackMenu> {
    private static final ResourceLocation TEX_3 = ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"textures/gui/backpack.png");
    private static final ResourceLocation TEX_6 = ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"textures/gui/bigbackpack.png");
    private final ResourceLocation texture;
    private final boolean scrollable;
    private float scrollAmount = 0.0f;
    private boolean scrolling = false;

    public BackpackScreen(BackpackMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        int rows = menu.getRows();
        this.imageWidth = 176;
        if (rows == 3) {
            this.imageHeight = 166;
            this.texture = TEX_3;
            this.scrollable = false;
        } else if (rows == 6) {
            this.imageHeight = 222;
            this.texture = TEX_6;
            this.scrollable = false;
        } else {
            this.imageHeight = 222;
            this.texture = TEX_6;
            this.scrollable = true;
        }
        this.titleLabelY = 6;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gg, mouseX, mouseY, partialTicks);
        super.render(gg, mouseX, mouseY, partialTicks);
        this.renderTooltip(gg, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        gg.blit(this.texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.scrollable) {
            this.renderScrollbar(gg, mouseX, mouseY);
        }
    }

    private void renderScrollbar(GuiGraphics gg, int mouseX, int mouseY) {
        int rows = ((BackpackMenu)this.menu).getRows();
        int maxOffset = rows - 6;
        if (maxOffset <= 0) {
            return;
        }
        int trackHeight = 108;
        int knobHeight = 15;
        int knobX = this.leftPos + 175;
        int knobY = this.topPos + 18 + (int)(this.scrollAmount * (float)(trackHeight - knobHeight));
        gg.fill(knobX, this.topPos + 18, knobX + 12, this.topPos + 18 + trackHeight, -5592406);
        boolean hovering = mouseX >= knobX && mouseX < knobX + 12 && mouseY >= knobY && mouseY < knobY + knobHeight;
        int knobColor = hovering || this.scrolling ? -8947849 : -11184811;
        gg.fill(knobX, knobY, knobX + 12, knobY + knobHeight, knobColor);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.adjustScrollByWheel(deltaY) || super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private boolean adjustScrollByWheel(double deltaY) {
        int rows = ((BackpackMenu)this.menu).getRows();
        int maxOffset = rows - 6;
        if (maxOffset <= 0) {
            return false;
        }
        float step = 1.0f / (float)maxOffset;
        this.scrollAmount = Math.max(0.0f, Math.min(1.0f, this.scrollAmount - (float)Math.signum(deltaY) * step));
        this.updateMenuScroll(maxOffset);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollable && button == 0) {
            int knobX = this.leftPos + 175;
            int knobTop = this.topPos + 18;
            int knobBottom = knobTop + 108;
            if (mouseX >= (double)knobX && mouseX < (double)(knobX + 12) && mouseY >= (double)knobTop && mouseY < (double)knobBottom) {
                this.scrolling = true;
                this.updateScrollFromMouse(mouseY);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    private void updateScrollFromMouse(double mouseY) {
        int rows = ((BackpackMenu)this.menu).getRows();
        int maxOffset = rows - 6;
        if (maxOffset <= 0) {
            return;
        }
        int trackTop = this.topPos + 18;
        int trackHeight = 108;
        int knobHeight = 15;
        this.scrollAmount = (float)(mouseY - (double)trackTop - (double)(knobHeight / 2)) / (float)(trackHeight - knobHeight);
        this.scrollAmount = Math.max(0.0f, Math.min(1.0f, this.scrollAmount));
        this.updateMenuScroll(maxOffset);
    }

    private void updateMenuScroll(int maxOffset) {
        int newOffset = Math.round(this.scrollAmount * (float)maxOffset);
        if (newOffset != ((BackpackMenu)this.menu).getScrollOffset()) {
            ((BackpackMenu)this.menu).setScrollOffset(newOffset);
        }
    }
}

