/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.network;

import com.craftyeddie.thenorthwildhunt.curios.backpack.BackpackItem;
import com.craftyeddie.thenorthwildhunt.menu.BackpackMenu;
import com.craftyeddie.thenorthwildhunt.network.OpenBackpackPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="thenorthwildhunt", bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("thenorthwildhunt");
        registrar.playToServer(OpenBackpackPayload.TYPE, OpenBackpackPayload.STREAM_CODEC, (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player != null) {
                NetworkHandler.openBackpackForPlayer(player);
            }
        });
    }

    private static void openBackpackForPlayer(final ServerPlayer player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findFirstCurio(s -> s.getItem() instanceof BackpackItem).ifPresent(curio -> {
            final ItemStack stack = curio.stack();
            final BackpackItem backpack = (BackpackItem)stack.getItem();
            final ItemStackHandler handler = backpack.getInventory(stack, player.level());
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                    return new BackpackMenu(id, inv, handler, stack, player.level(), backpack.getRows());
                }
            }, buf -> buf.writeVarInt(backpack.getRows()));
        }));
    }
}

