/*
 * Decompiled with CFR 0.152.
 */
package com.craftyeddie.thenorthwildhunt.network;

import com.craftyeddie.thenorthwildhunt.curios.backpack.BackpackItem;
import com.craftyeddie.thenorthwildhunt.menu.BackpackMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public record OpenBackpackPayload() implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"thenorthwildhunt", (String)"open_backpack");
    public static final CustomPacketPayload.Type<OpenBackpackPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, OpenBackpackPayload> STREAM_CODEC = StreamCodec.of((buf, payload) -> {}, buf -> new OpenBackpackPayload());

    public CustomPacketPayload.Type<OpenBackpackPayload> type() {
        return TYPE;
    }

    public static void handle(OpenBackpackPayload msg, final ServerPlayer player) {
        Item item;
        final ItemStack stack = OpenBackpackPayload.findBackpack((Player)player);
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof BackpackItem)) {
            return;
        }
        BackpackItem backpack = (BackpackItem)item;
        final int rows = backpack.getRows();
        final ItemStackHandler handler = backpack.getInventory(stack, player.level());
        MenuProvider provider = new MenuProvider(){

            public Component getDisplayName() {
                return stack.getHoverName();
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inv, Player p) {
                return new BackpackMenu(containerId, inv, handler, stack, player.level(), rows);
            }
        };
        player.openMenu(provider, buf -> buf.writeVarInt(rows));
    }

    private static ItemStack findBackpack(Player player) {
        ItemStack main = player.getMainHandItem();
        if (main.getItem() instanceof BackpackItem) {
            return main;
        }
        ItemStack off = player.getOffhandItem();
        if (off.getItem() instanceof BackpackItem) {
            return off;
        }
        return ItemStack.EMPTY;
    }
}

