/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.cat;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.CatFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.cat.CatMarkingOverlay;
import com.dragn0007.dragnpets.entities.cat.OCatEyeLayer;
import com.dragn0007.dragnpets.entities.cat.OCatModel;
import com.dragn0007.dragnpets.items.POItems;
import com.dragn0007.dragnpets.util.POTags;
import com.dragn0007.dragnpets.util.PetsOverhaulCommonConfig;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OCat
extends TamableAnimal
implements GeoEntity {
    @Nullable
    public OcelotAvoidEntityGoal<Player> ocelotAvoidPlayersGoal;
    @Nullable
    public OcelotTemptGoal temptGoal;
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_ocelot");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/cat");
    private static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/cat");
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType entitytype = entity.m_6095_();
        return entitytype == EntityTypes.O_RABBIT_ENTITY.get() || entitytype == EntityTypes.O_CHICKEN_ENTITY.get() || entitytype == EntityTypes.O_FROG_ENTITY.get() || entitytype == POEntityTypes.MACAW_ENTITY.get() || entitytype == POEntityTypes.COCKATIEL_ENTITY.get() || entitytype == POEntityTypes.RINGNECK_ENTITY.get();
    };
    public int giftTime;
    public final AnimatableInstanceCache geoCache;
    public int regenHealthCounter;
    public int wagCounter;
    public int stayWaggingCounter;
    private boolean wag;
    public boolean toldToWander;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.CAT_FOOD);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OCat(EntityType<? extends OCat> entityType, Level level) {
        super(entityType, level);
        this.giftTime = this.f_19796_.m_188503_(24000) + 48000;
        this.geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.regenHealthCounter = 0;
        this.wagCounter = this.f_19796_.m_188503_(1200) + 1200;
        this.stayWaggingCounter = 0;
        this.wag = false;
        this.toldToWander = false;
        this.m_7105_(false);
        this.reassessTrustingGoals();
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public void reassessTrustingGoals() {
        if (this.ocelotAvoidPlayersGoal == null) {
            this.ocelotAvoidPlayersGoal = new OcelotAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.ocelotAvoidPlayersGoal);
        this.f_21345_.m_25352_(4, this.ocelotAvoidPlayersGoal);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.temptGoal = new OcelotTemptGoal(this, 0.6, FOOD_ITEMS, true);
        this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(8, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(6, (Goal)new CatFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 2, true, false, entity -> entity.m_6095_().m_204039_(POTags.Entity_Types.CATS_HUNT) && (entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() || !this.m_21824_() || this.m_21824_() && this.wasToldToWander() && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_())){});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.giftTime <= 0 && ((Boolean)PetsOverhaulCommonConfig.CATS_GIVE_GIFTS.get()).booleanValue() && this.m_21824_() && !this.wasToldToWander() && !this.m_21827_()) {
            this.m_5496_(SoundEvents.f_11793_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            int i = this.m_217043_().m_188503_(100);
            if (i < 15) {
                this.m_19998_((ItemLike)Items.f_42401_);
            } else if (i < 20) {
                this.m_19998_((ItemLike)Items.f_42649_);
            } else if (i < 25) {
                this.m_19998_((ItemLike)Items.f_42402_);
            } else if (i < 35) {
                this.m_19998_((ItemLike)Items.f_41953_);
            } else if (i < 45) {
                this.m_19998_((ItemLike)Items.f_42499_);
            } else if (i < 55) {
                this.m_19998_((ItemLike)Items.f_42398_);
            } else if (i < 65) {
                this.m_19998_((ItemLike)LOItems.CHICKEN_THIGH.get());
            } else if (i < 70) {
                this.m_19998_((ItemLike)POItems.PARROT_THIGH.get());
            } else if (i < 75) {
                this.m_19998_((ItemLike)LOItems.FROG.get());
            } else if (i < 80) {
                this.m_19998_((ItemLike)Items.f_42527_);
            } else if (i < 85) {
                this.m_19998_((ItemLike)Items.f_42526_);
            } else if (i < 90) {
                this.m_19998_((ItemLike)Items.f_41870_);
            } else if (i < 95) {
                this.m_19998_((ItemLike)Items.f_42403_);
            } else if ((double)i < 98.5) {
                this.m_19998_((ItemLike)Items.f_42648_);
            } else if ((double)i < 99.0) {
                this.m_19998_((ItemLike)LOItems.COOKED_CHICKEN_THIGH.get());
            } else if ((double)i < 99.5) {
                this.m_19998_((ItemLike)Items.f_42701_);
            } else if (i < 100) {
                this.m_19998_((ItemLike)Items.f_42682_);
            }
            this.giftTime = this.f_19796_.m_188503_(24000) + 48000;
        }
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.02;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.5);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.5);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else if (this.isWagging()) {
            controller.setAnimation(RawAnimation.begin().then("flick_tail", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.9f;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d0 == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    public boolean isWagging() {
        return this.wag;
    }

    public void setWagging(boolean wagging) {
        this.wag = wagging;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.wagCounter;
        if (--this.wagCounter <= 0) {
            ++this.stayWaggingCounter;
            this.setWagging(true);
            if (this.stayWaggingCounter >= 300) {
                this.wagCounter = this.f_19796_.m_188503_(1200) + 1200;
                this.stayWaggingCounter = 0;
                this.setWagging(false);
            }
        }
        ++this.regenHealthCounter;
        if (this.m_21223_() < this.m_21233_() && this.regenHealthCounter >= 150 && this.m_21824_() && this.m_6084_()) {
            this.m_21153_(this.m_21223_() + 2.0f);
            this.regenHealthCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
        }
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Nullable
    public SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return SoundEvents.f_11792_;
            }
            return this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
        }
        return SoundEvents.f_11786_;
    }

    public int m_8100_() {
        return 120;
    }

    public SoundEvent m_7975_(DamageSource p_28160_) {
        return SoundEvents.f_11791_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_28990_) {
        return p_28990_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            this.m_21153_(10.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_(Items.f_42574_) && this.isCollared()) {
            this.setCollared(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            return InteractionResult.PASS;
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && !this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(true);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(false);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_204117_(POTags.Items.CAT_FOOD) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)player)) {
                    this.setCollared(true);
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, hand);
                }
            }
            if ((!(interactionresult = super.m_6071_(player, hand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_204117_(POTags.Items.CAT_FOOD)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public ResourceLocation getTextureLocation() {
        return OCatModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return CatMarkingOverlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public ResourceLocation getEyeLocation() {
        return OCatEyeLayer.Eyes.overlayFromOrdinal((int)this.getEyes()).resourceLocation;
    }

    public int getEyes() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public void setEyes(int eyes) {
        this.f_19804_.m_135381_(EYES, (Object)eyes);
    }

    public boolean isCollared() {
        return (Boolean)this.f_19804_.m_135370_(COLLARED);
    }

    public void setCollared(boolean collared) {
        this.f_19804_.m_135381_(COLLARED, (Object)collared);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyes(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Eyes", this.getEyes());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setEyeColor();
        } else {
            this.setEyes(random.nextInt(OCatEyeLayer.Eyes.values().length));
        }
        this.setVariant(random.nextInt(OCatModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(CatMarkingOverlay.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void setEyeColor() {
        if (this.getVariant() == 4 || this.getVariant() == 14 || this.getOverlayVariant() == 85) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setEyes(5);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.1) {
                this.setEyes(4);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setEyes(this.m_217043_().m_188503_(3));
            } else {
                this.setEyes(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.03) {
            this.setEyes(5);
        } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.03) {
            this.setEyes(4);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setEyes(this.m_217043_().m_188503_(3));
        } else {
            this.setEyes(0);
        }
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OCat)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OCat)animal).canParent();
        }
        OCat partner = (OCat)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OCat partner = (OCat)ageableMob;
        OCat kitten = (OCat)((EntityType)POEntityTypes.O_CAT_ENTITY.get()).m_20615_((Level)serverLevel);
        int variantChance = this.f_19796_.m_188503_(14);
        int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OCatModel.Variant.values().length));
        kitten.setVariant(variant);
        int overlayChance = this.f_19796_.m_188503_(10);
        int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(CatMarkingOverlay.values().length));
        kitten.setOverlayVariant(overlay);
        int eyeChance = this.f_19796_.m_188503_(10);
        int eyes = eyeChance < 4 ? this.getEyes() : (eyeChance < 8 ? partner.getEyes() : this.f_19796_.m_188503_(OCatEyeLayer.Eyes.values().length));
        kitten.setEyes(eyes);
        int gender = this.f_19796_.m_188503_(Gender.values().length);
        kitten.setGender(gender);
        return kitten;
    }

    public boolean m_6573_(Player p_30396_) {
        return super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_7822_(byte p_28995_) {
        if (p_28995_ == 41) {
            this.spawnTrustingParticles(true);
        } else if (p_28995_ == 40) {
            this.spawnTrustingParticles(false);
        } else {
            super.m_7822_(p_28995_);
        }
    }

    public void spawnTrustingParticles(boolean p_29048_) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!p_29048_) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_20161_() {
        return this.m_6047_() || super.m_20161_();
    }

    static class OcelotAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public final OCat ocelot;

        public OcelotAvoidEntityGoal(OCat p_29051_, Class<T> p_29052_, float p_29053_, double p_29054_, double p_29055_) {
            super((PathfinderMob)p_29051_, p_29052_, p_29053_, p_29054_, p_29055_, EntitySelector.f_20406_::test);
            this.ocelot = p_29051_;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class OcelotTemptGoal
    extends TemptGoal {
        public final OCat ocelot;

        public OcelotTemptGoal(OCat p_29060_, double p_29061_, Ingredient p_29062_, boolean p_29063_) {
            super((PathfinderMob)p_29060_, p_29061_, p_29062_, p_29063_);
            this.ocelot = p_29060_;
        }

        public boolean m_7497_() {
            return super.m_7497_();
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

