/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.dog;

import com.dragn0007.dragnpets.entities.dog.CommonDog;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CommonDogModel
extends DefaultedEntityGeoModel<CommonDog> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/dog/o_dog.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/dog.animation.json");

    public CommonDogModel() {
        super(new ResourceLocation("dragnlivestock", "o_dog"), true);
    }

    public void setCustomAnimations(CommonDog animatable, long instanceId, AnimationState<CommonDog> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(CommonDog object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(CommonDog object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(CommonDog animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnpets", "textures/entity/dog/black.png")),
        BLUE(new ResourceLocation("dragnpets", "textures/entity/dog/blue.png")),
        BROWN(new ResourceLocation("dragnpets", "textures/entity/dog/brown.png")),
        CHOCOLATE(new ResourceLocation("dragnpets", "textures/entity/dog/chocolate.png")),
        CREAM(new ResourceLocation("dragnpets", "textures/entity/dog/cream.png")),
        FAWN(new ResourceLocation("dragnpets", "textures/entity/dog/fawn.png")),
        GOLD_RED(new ResourceLocation("dragnpets", "textures/entity/dog/gold_red.png")),
        LILAC(new ResourceLocation("dragnpets", "textures/entity/dog/lilac.png")),
        MAHOGANY(new ResourceLocation("dragnpets", "textures/entity/dog/mahogany.png")),
        RED(new ResourceLocation("dragnpets", "textures/entity/dog/red.png")),
        SEAL(new ResourceLocation("dragnpets", "textures/entity/dog/seal.png")),
        SILVER(new ResourceLocation("dragnpets", "textures/entity/dog/silver.png")),
        TAN(new ResourceLocation("dragnpets", "textures/entity/dog/tan.png")),
        WHITE(new ResourceLocation("dragnpets", "textures/entity/dog/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

