/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.ocelot;

import com.dragn0007.dragnpets.entities.ocelot.OOcelot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OOcelotModel
extends DefaultedEntityGeoModel<OOcelot> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/o_ocelot.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/o_cat.animation.json");

    public OOcelotModel() {
        super(new ResourceLocation("dragnlivestock", "o_ocelot"), true);
    }

    public void setCustomAnimations(OOcelot animatable, long instanceId, AnimationState<OOcelot> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OOcelot object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OOcelot object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OOcelot animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnpets", "textures/entity/ocelot/black.png")),
        CREAM(new ResourceLocation("dragnpets", "textures/entity/ocelot/cream.png")),
        LILAC(new ResourceLocation("dragnpets", "textures/entity/ocelot/lilac.png")),
        SILVER(new ResourceLocation("dragnpets", "textures/entity/ocelot/silver.png")),
        WHITE(new ResourceLocation("dragnpets", "textures/entity/ocelot/white.png")),
        YELLOW(new ResourceLocation("dragnpets", "textures/entity/ocelot/yellow.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

