/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.parrot;

import com.dragn0007.dragnpets.entities.parrot.Cockatiel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CockatielModel
extends DefaultedEntityGeoModel<Cockatiel> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/cockatiel.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/cockatiel.animation.json");
    public static final ResourceLocation BABY_TEXTURE = new ResourceLocation("dragnpets", "textures/entity/parrot/parrot_baby.png");

    public CockatielModel() {
        super(new ResourceLocation("dragnlivestock", "cockatiel"), true);
    }

    public void setCustomAnimations(Cockatiel animatable, long instanceId, AnimationState<Cockatiel> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Cockatiel object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Cockatiel object) {
        if (object.m_6162_()) {
            return BABY_TEXTURE;
        }
        return object.getTextureResource();
    }

    public ResourceLocation getAnimationResource(Cockatiel animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        GREY(new ResourceLocation("dragnpets", "textures/entity/parrot/cockatiel/cockatiel_grey.png")),
        PINK(new ResourceLocation("dragnpets", "textures/entity/parrot/cockatiel/cockatiel_pink.png")),
        WHITE(new ResourceLocation("dragnpets", "textures/entity/parrot/cockatiel/cockatiel_white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

