/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.parrot;

import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.ai.ParrotFollowOwnerGoal;
import com.dragn0007.dragnpets.util.POTags;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OParrot
extends TamableAnimal
implements GeoEntity,
FlyingAnimal {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_parrot");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/parrot");
    public static final Predicate<Mob> NOT_PARROT_PREDICATE = new Predicate<Mob>(){

        @Override
        public boolean test(@Nullable Mob p_29453_) {
            return p_29453_ != null && MOB_SOUND_MAP.containsKey(p_29453_.m_6095_());
        }
    };
    public static final Item POISONOUS_FOOD = Items.f_42572_;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.PARROT_FOOD);
    static final Map<EntityType<?>, SoundEvent> MOB_SOUND_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_29398_ -> {
        p_29398_.put(EntityType.f_20551_, SoundEvents.f_12246_);
        p_29398_.put(EntityType.f_20554_, SoundEvents.f_12268_);
        p_29398_.put(EntityType.f_20558_, SoundEvents.f_12247_);
        p_29398_.put(EntityType.f_20562_, SoundEvents.f_12248_);
        p_29398_.put(EntityType.f_20563_, SoundEvents.f_12249_);
        p_29398_.put(EntityType.f_20565_, SoundEvents.f_12250_);
        p_29398_.put(EntityType.f_20567_, SoundEvents.f_12251_);
        p_29398_.put(EntityType.f_20568_, SoundEvents.f_12252_);
        p_29398_.put(EntityType.f_20453_, SoundEvents.f_12253_);
        p_29398_.put(EntityType.f_20455_, SoundEvents.f_12254_);
        p_29398_.put(EntityType.f_20456_, SoundEvents.f_12255_);
        p_29398_.put(EntityType.f_20458_, SoundEvents.f_12256_);
        p_29398_.put(EntityType.f_20459_, SoundEvents.f_12257_);
        p_29398_.put(EntityType.f_20468_, SoundEvents.f_12258_);
        p_29398_.put(EntityType.f_20509_, SoundEvents.f_12259_);
        p_29398_.put(EntityType.f_20511_, SoundEvents.f_12260_);
        p_29398_.put(EntityType.f_20512_, SoundEvents.f_12261_);
        p_29398_.put(EntityType.f_20513_, SoundEvents.f_12262_);
        p_29398_.put(EntityType.f_20518_, SoundEvents.f_12263_);
        p_29398_.put(EntityType.f_20521_, SoundEvents.f_12264_);
        p_29398_.put(EntityType.f_20523_, SoundEvents.f_12265_);
        p_29398_.put(EntityType.f_20524_, SoundEvents.f_12266_);
        p_29398_.put(EntityType.f_20526_, SoundEvents.f_12267_);
        p_29398_.put(EntityType.f_20479_, SoundEvents.f_12268_);
        p_29398_.put(EntityType.f_20481_, SoundEvents.f_12269_);
        p_29398_.put(EntityType.f_20491_, SoundEvents.f_12270_);
        p_29398_.put(EntityType.f_20493_, SoundEvents.f_12271_);
        p_29398_.put(EntityType.f_217015_, SoundEvents.f_215733_);
        p_29398_.put(EntityType.f_20495_, SoundEvents.f_12220_);
        p_29398_.put(EntityType.f_20496_, SoundEvents.f_12221_);
        p_29398_.put(EntityType.f_20497_, SoundEvents.f_12222_);
        p_29398_.put(EntityType.f_20500_, SoundEvents.f_12223_);
        p_29398_.put(EntityType.f_20501_, SoundEvents.f_12224_);
        p_29398_.put(EntityType.f_20530_, SoundEvents.f_12225_);
    });
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int regenHealthCounter = 0;
    public boolean toldToWander = false;
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OParrot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OParrot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public static boolean imitateNearbyMobs(Level p_29383_, Entity p_29384_) {
        if (p_29384_.m_6084_() && !p_29384_.m_20067_() && p_29383_.f_46441_.m_188503_(2) == 0) {
            Mob mob;
            List list = p_29383_.m_6443_(Mob.class, p_29384_.m_20191_().m_82400_(20.0), NOT_PARROT_PREDICATE);
            if (!list.isEmpty() && !(mob = (Mob)list.get(p_29383_.f_46441_.m_188503_(list.size()))).m_20067_()) {
                SoundEvent soundevent = OParrot.getImitatedSound(mob.m_6095_());
                p_29383_.m_6263_((Player)null, p_29384_.m_20185_(), p_29384_.m_20186_(), p_29384_.m_20189_(), soundevent, p_29384_.m_5720_(), 0.7f, OParrot.getPitch(p_29383_.f_46441_));
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46441_.m_188503_(400) == 0) {
            OParrot.imitateNearbyMobs(this.m_9236_(), (Entity)this);
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity p_29365_) {
        return p_29365_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 3.0f);
    }

    public OParrot(EntityType<? extends OParrot> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new ParrotFollowOwnerGoal(this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new ParrotWanderGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public PathNavigation m_6037_(Level p_29417_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_29417_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            controller.setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(3.0);
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.3);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.regenHealthCounter;
        if (this.m_21223_() < this.m_21233_() && this.regenHealthCounter >= 150 && this.m_21824_() && this.m_6084_()) {
            this.m_21153_(this.m_21223_() + 2.0f);
            this.regenHealthCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            return InteractionResult.PASS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && !this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(true);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(false);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && itemstack.m_204117_(POTags.Items.PARROT_FOOD) && !this.m_27593_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12190_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
            this.m_27595_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_21824_() && itemstack.m_204117_(POTags.Items.PARROT_FOOD)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12190_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_(POISONOUS_FOOD)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 900));
            if (player.m_7500_() || !this.m_20147_()) {
                this.m_6469_(this.m_269291_().m_269075_(player), Float.MAX_VALUE);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_29443_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    @Nullable
    public SoundEvent m_7515_() {
        return OParrot.getAmbient(this.m_9236_(), this.m_9236_().f_46441_);
    }

    public static SoundEvent getAmbient(Level p_218239_, RandomSource p_218240_) {
        if (p_218239_.m_46791_() != Difficulty.PEACEFUL && p_218240_.m_188503_(1000) == 0) {
            ArrayList list = Lists.newArrayList(MOB_SOUND_MAP.keySet());
            return OParrot.getImitatedSound((EntityType)list.get(p_218240_.m_188503_(list.size())));
        }
        return SoundEvents.f_12188_;
    }

    public static SoundEvent getImitatedSound(EntityType<?> p_29409_) {
        return MOB_SOUND_MAP.getOrDefault(p_29409_, SoundEvents.f_12188_);
    }

    public SoundEvent m_7975_(DamageSource p_29437_) {
        return SoundEvents.f_12192_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12189_;
    }

    public void m_7355_(BlockPos p_29419_, BlockState p_29420_) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    public float m_6100_() {
        return OParrot.getPitch(this.f_19796_);
    }

    public static float getPitch(RandomSource p_218237_) {
        return (p_218237_.m_188501_() - p_218237_.m_188501_()) * 0.2f + 1.0f;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_7324_(Entity p_29367_) {
        if (!(p_29367_ instanceof Player)) {
            super.m_7324_(p_29367_);
        }
    }

    public boolean m_6469_(DamageSource p_29378_, float p_29379_) {
        if (this.m_6673_(p_29378_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(p_29378_, p_29379_);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Wandering", this.getToldToWander());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(Gender.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_6573_(Player p_30396_) {
        return super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    static class ParrotWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public ParrotWanderGoal(PathfinderMob p_186224_, double p_186225_) {
            super(p_186224_, p_186225_);
        }

        @Nullable
        public Vec3 m_7037_() {
            Vec3 vec3 = null;
            if (this.f_25725_.m_20069_()) {
                vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)15);
            }
            if (this.f_25725_.m_217043_().m_188501_() >= this.f_25985_) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.m_7037_() : vec3;
        }

        @Nullable
        public Vec3 getTreePos() {
            BlockPos blockpos = this.f_25725_.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.f_25725_.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos1, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockstate.m_204336_(BlockTags.f_13106_)) || !this.f_25725_.m_9236_().m_46859_(blockpos1) || !this.f_25725_.m_9236_().m_46859_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

